package com.cloud.hisavana.sdk.common.widget.webview;

import android.os.MessageQueue;
import android.text.TextUtils;

import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.transsion.core.pool.TranssionPoolManager;

import java.io.File;
import java.util.List;

public class AssetCleanTask implements MessageQueue.IdleHandler {
    private final List<WebUrlData> mWebDataList;

    public AssetCleanTask(List<WebUrlData> webDataList) {
        this.mWebDataList = webDataList;
    }

    @Override
    public boolean queueIdle() {
        AdLogUtil.Log().d("webview--","AssetCleanTask start clean when idle");
        TranssionPoolManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                try {
                    String webAssetPath = WebAssetsManager.getWebAssetPath();
                    if (TextUtils.isEmpty(webAssetPath) || mWebDataList == null || mWebDataList.isEmpty()) {
                        return;
                    }
                    File file = new File(webAssetPath);
                    if (file.isDirectory()) {
                        String[] list = file.list();
                        if (list != null && list.length > 0) {
                            int needDeleteNum = 0;
                            for (int i = 0; i < list.length; i++) {
                                String fileName = list[i];
                                boolean exist = false;
                                for (WebUrlData webUrlData : mWebDataList) {
                                    if (webUrlData == null || TextUtils.isEmpty(webUrlData.getUrl())) {
                                        continue;
                                    }
                                    String url = webUrlData.getUrl();
                                    if (TextUtils.equals(WebAssetsManager.getWebAssetName(url), fileName)) {
                                        exist = true;
                                        break;
                                    }
                                    exist = false;

                                }
                                if (!exist) {
                                    needDeleteNum++;
                                    boolean delete = WebAssetsManager.deleteWebAsset(webAssetPath + File.separator + fileName);
                                    if (delete) {
                                    }
                                }
                            }
                            AdLogUtil.Log().d("webview--","AssetCleanTask current time delete num = " + needDeleteNum);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return false;
    }
}
