package com.cloud.hisavana.sdk.common.widget.webview;

import android.net.Uri;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;

public class MimeTypeMapUtils {

    public static String checkMimeType(String assetUrl) {
        String mimeType = "";
        try {
            if (!TextUtils.isEmpty(assetUrl)) {
                if (Uri.parse(assetUrl).getPath().contains(".js")) {
                    mimeType = "text/javascript";
                } else {
                    String fileExtensionFromUrl = MimeTypeMap.getSingleton().getFileExtensionFromUrl(assetUrl);
                    if (!TextUtils.isEmpty(fileExtensionFromUrl)) {
                        mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtensionFromUrl);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return mimeType;
    }
}
