package com.cloud.hisavana.sdk.common.widget.webview;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;

import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.widget.net.HttpManager;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebNativeLoader {

    private WebNativeLoader() {
    }

    public static void preload(final List<WebUrlData> webDataList) {
        new Handler(Looper.getMainLooper()).post(new Runnable() {
            @Override
            public void run() {
                preloadInner(webDataList);
            }
        });
    }

    private static void preloadInner(final List<WebUrlData> webDataList) {
        if (webDataList != null && !webDataList.isEmpty()) {
            AdLogUtil.Log().d("webview--","TWebViewNativeLoader size = " + webDataList.size());
            preloadAssetIfExist(webDataList);
            cleanAssetIfRemoved(webDataList);
        }
    }

    private static void cleanAssetIfRemoved(List<WebUrlData> webDataList) {
        if (webDataList != null && !webDataList.isEmpty()) {
            Looper.myQueue().addIdleHandler(new AssetCleanTask(webDataList));
        }
    }

    private static void preloadAssetIfExist(List<WebUrlData> webDataList) {
        if (webDataList != null && !webDataList.isEmpty()) {
            int needPreloadNum = 0;
            for (WebUrlData webUrlData : webDataList) {
                if (webUrlData == null) {
                    continue;
                }
                if (checkAssetExist(webUrlData.getUrl())) {
                    continue;
                }
                needPreloadNum++;
                Looper.myQueue().addIdleHandler(new IdleDownloadTask(webUrlData));
            }
            AdLogUtil.Log().d("webview--","TWebViewNativeLoader need preload num = " + needPreloadNum);
        }
    }

    private static boolean checkAssetExist(String url) {
        if (!TextUtils.isEmpty(url) && WebAssetsManager.checkWebAssetExist(url)) {
            return true;
        }
        return false;
    }

    public static void post(String urlPath, Map<String, String> headers, JSONObject paramsObj, HttpManager.OnRequestCallback callback) {
        if (headers == null) {
            headers = new HashMap<>();
        }
        headers.put("Accept-Timezone", "UTC");
        HttpManager.post(urlPath, headers, paramsObj, callback);
    }
}
