package com.cloud.hisavana.sdk.common.widget.webview;

import android.app.Activity;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import android.webkit.ValueCallback;
import android.webkit.WebView;

import androidx.annotation.Nullable;

import com.cloud.hisavana.sdk.common.activity.TAdExposureActivity;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.widget.net.HttpManager;
import com.tmc.webview.CoreJsBridge;

import org.json.JSONObject;

import java.lang.ref.WeakReference;

public class WebViewInterface extends CoreJsBridge {

    private final WebView mWebView;
    private final Handler mMainHandler;
    private final WeakReference<Activity> mWebViewActivity;

    public WebViewInterface(Activity webViewActivity, WebView webview) {
        this.mWebViewActivity = new WeakReference<>(webViewActivity);
        this.mWebView = webview;
        this.mMainHandler = new Handler(Looper.getMainLooper());
    }

    @JavascriptInterface
    public String checkNativeLoad() {
        AdLogUtil.Log().d("webview--","WebViewInterface checkNativeLoad");
        return WebViewManager.optimize() ? "1" : "";
    }

    @JavascriptInterface
    public void onLoadByNative(final String jsonStr, final String callbackName) {
        AdLogUtil.Log().d("webview--","WebViewInterface onLoadByNative, jsonStr = " + jsonStr + " callbackName = " + callbackName );
        if (TextUtils.isEmpty(callbackName)) {
            return;
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(jsonStr);
        } catch (Exception e) {
            e.printStackTrace();
        }
        String requestUrl = null;
        JSONObject paramJo = null;
        if (jsonObject != null) {
            requestUrl = jsonObject.optString("requestUrl");
            paramJo = jsonObject.optJSONObject("requestParam");
        }
        if (TextUtils.isEmpty(requestUrl)) {
            executeJavascript(callbackName, "");
            return;
        }
        requestUrl = checkToRepairUrlIfNeeded(requestUrl);
        AdLogUtil.Log().d("webview--","WebViewInterface onLoadByNative, jsonStr = " + jsonStr + " callbackName = " + callbackName + " final url = " + requestUrl);
        WebNativeLoader.post(requestUrl, null, paramJo, new HttpManager.OnRequestCallback() {
            @Override
            public void onSuccess(String response) {
                AdLogUtil.Log().d("webview--","WebViewInterface onSuccess = " + response);
                executeJavascript(callbackName, response);
            }

            @Override
            public void onFail(int code, String message) {
                AdLogUtil.Log().d("webview--","WebViewInterface onFail, code = " + code + " error = " + message);
                executeJavascript(callbackName, "");
            }
        });
    }


    //String jscode = "javascript:callback('" + callBackName + "'," + response + ")";
    private void executeJavascript(final String callbackName, final String response) {
        mMainHandler.post(new Runnable() {
            @Override
            public void run() {
                if (mWebView == null) {
                    return;
                }
                String js = "javascript:" + callbackName + "(" + response + ")";
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                    mWebView.evaluateJavascript(js, new ValueCallback<String>() {
                        @Override
                        public void onReceiveValue(String value) {
                            AdLogUtil.Log().d("webview--","WebViewInterface executeJavascript, onReceiveValue = " + value);
                        }
                    });
                } else {
                    mWebView.loadUrl(js);
                }
            }
        });
    }


    private String checkToRepairUrlIfNeeded(String requestUrl) {
        if (TextUtils.isEmpty(requestUrl)) {
            return requestUrl;
        }
        if (!requestUrl.startsWith("https") && !requestUrl.startsWith("http")) {
            requestUrl = TextUtils.concat("https://", requestUrl).toString();
        }
        return requestUrl;
    }

    @JavascriptInterface
    public void onWebComplete() {
        AdLogUtil.Log().d("webview--","WebViewInterface onWebComplete");
        if (mWebViewActivity != null && mWebViewActivity.get() != null && mWebViewActivity.get() instanceof TAdExposureActivity) {
            mMainHandler.post(new Runnable() {
                @Override
                public void run() {
                    TAdExposureActivity activity = (TAdExposureActivity) mWebViewActivity.get();
                    activity.trackWebViewComplete();
                }
            });
        }
    }

    @Nullable
    @Override
    public String getSystemInfo() {
        return null;
    }

    @Override
    public void goBack() {
         if(null !=mWebView && mWebView.canGoBack()){
             mWebView.goBack();
         } else if(null !=mWebViewActivity.get() ){
             mWebViewActivity.get().finish();
         }
    }
}
