package com.cloud.hisavana.sdk.common.widget.webview;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;

import com.cloud.hisavana.sdk.BuildConfig;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.widget.config.Config;
import com.cloud.hisavana.sdk.common.widget.config.ConfigData;

import java.io.InputStream;
import java.util.List;

public class WebViewManager {

    private static boolean mOptimize = false;
    private static Context mContext;

    private WebViewManager() {
    }

    public static void init(final Context context) {
        mContext = context.getApplicationContext();
        if (optimize()) {
            initWebView();
            initConfigAndPreloadAsset(context);
        }
        //WebViewAssetFormat.format();
    }

    private static void initWebView() {
        prepare();
    }

    private static void initConfigAndPreloadAsset(Context context) {
        Config.init(context, new Config.OnConfigCallback() {
            @Override
            public void onCallback(ConfigData configData) {
                if (configData != null && configData.getDataObj() != null) {
                    try {
                        List<WebUrlData> webUrlDataList = WebViewConfigParser.parse(configData.getDataObj().getJSONArray("webview"));
                        WebNativeLoader.preload(webUrlDataList);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private static void prepare() {
        if (optimize()) {
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable() {
                @Override
                public void run() {
                    Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler() {
                        @Override
                        public boolean queueIdle() {
                            long start = System.currentTimeMillis();
                            final WebView webView = createWebView(mContext);
                            if (webView != null) {
                                handler.postDelayed(new Runnable() {
                                    @Override
                                    public void run() {
                                        destroy(webView);
                                    }
                                }, 2000);
                            }
                            AdLogUtil.Log().d("webview--", "prepare webview, duration = " + (System.currentTimeMillis() - start));
                            return false;
                        }
                    });
                }
            });
        }
    }

    public static boolean checkAssetsExist(String url) {
        if (optimize()) {
            url = forDebug(url);
            return WebAssetsManager.checkWebAssetExist(url);
        }
        return false;
    }

    private static String forDebug(String url) {
        if (BuildConfig.DEBUG) {
            if (url.contains("10.150.248.63:8888")) {
                url = url.replace("10.150.248.63:8888", "ipage.test.eagllwin.com");
            }
            return url;
        }
        return url;
    }

    public static WebResourceResponse onInterceptRequest(String assetsUrl) {
        if (optimize() && !TextUtils.isEmpty(assetsUrl)) {
            try {
                assetsUrl = forDebug(assetsUrl);
                InputStream webAssetStream = WebAssetsManager.getWebAssetStream(assetsUrl);
                if (webAssetStream != null) {
                    WebResourceResponse resourceResponse =
                            new WebResourceResponse(MimeTypeMapUtils.checkMimeType(assetsUrl), "UTF-8", webAssetStream);
                    return resourceResponse;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /**
     * 这个方法不管是A组还是B组都要注入，因为不分AB,都要进行打点
     *
     * @param webViewActivity
     * @param webview
     */
    public static void addJavaScriptInterface(Activity webViewActivity, WebView webview) {
        AdLogUtil.Log().d("webview--", "addJavaScriptInterface");
        WebViewInterface webViewInterfaceSsp = new WebViewInterface(webViewActivity, webview);
        WebViewInterface webViewInterfaceLofin = new WebViewInterface(webViewActivity, webview);
        addJavaScriptInterface(webview, webViewInterfaceSsp, "sspWebview");
      //  addJavaScriptInterface(webview, webViewInterfaceLofin, "login");
    }

    @SuppressLint("JavascriptInterface")
    public static void addJavaScriptInterface(WebView webview, Object object, String name) {
        webview.getSettings().setJavaScriptEnabled(true);
        webview.addJavascriptInterface(object, name);
    }

    private static WebView createWebView(Context context) {
        return new WebView(context);
    }

    public static void destroy(WebView webView) {
        if (optimize()) {
            if (webView != null) {
                ViewParent parent = webView.getParent();
                if (parent != null) {
                    ((ViewGroup) parent).removeView(webView);
                }
                webView.stopLoading();
                webView.getSettings().setJavaScriptEnabled(false);
                webView.clearHistory();
                webView.removeAllViews();
                webView.destroy();
                webView = null;
                AdLogUtil.Log().d("webview--", "destroy webview");
            }
        }
    }

    public static boolean optimize() {
        return mOptimize;
    }

    public static void updateOptimize(boolean optimize) {
        mOptimize = optimize;
    }
}
