package com.cloud.hisavana.sdk.data.bean.response;

import android.content.pm.PackageInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;

import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.ps.PsRequestManager;
import com.cloud.hisavana.sdk.common.util.AESUtils;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.google.gson.annotations.SerializedName;
import com.transsion.core.CoreUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author: wenjing.luo
 * @date: 2021/8/5
 * 服务器返回广告数据bean
 */
public class TAdsDTO implements Serializable {
    Integer id; //自增id
    Long advertiserId; //广告主id
    Long planId; //计划id

    @Deprecated
    String planType; //1.2版本新增 计划类型
    Long adGroupId; //广告组id
    Long adCreativeId; //广告创意id
    @Deprecated
    Integer cost; //价格(美分）/CPM
    @Deprecated
    Double bidPrice; // 1.2版本新增 竞价价格（美分）
    String packageName; // 包名
    Integer cacheTime;//缓存时长：开屏-4、其他-1 （小时）
    String clickUrl; // 点击链接地址
    List<AbTestDTO> abTest;
    //1.3.0之前的版本需要
    @Deprecated
    String deepLinkUrl; //应用深链接地址
    @SerializedName("clickUrls")
    ArrayList<String> storeDeeplink; //应用深链接地址
    ArrayList<String> showTrackingUrls; // 当广告展示后，触发此字段中的tracking url
    String showTrackingSecretKey; //曝光加密串
    ArrayList<String> clickTrackingUrls; //当广告被点击后，触发此字段中的tracking url

    String adChoiceImageUrl;//广告平台标志图片地址 商标
    String adChoiceClickUrl;//广告平台标志链接地址 点击商标后的落地
    String adChoiceLegalText;//广告平台标志法律条文 不用

    String defaultAdExpirationTime;//打底广告到期时间,时间格式同上
    Integer defaultAdShowCount;//打底广告曝光次数

    // 1.2版本之后 弃用，保留字段兼容老版本
    @Deprecated
    String imageUrl;//图片链接
    @Deprecated
    Integer imageWidth;
    @Deprecated
    Integer imageHeight;

    NativeBean nativeObject; // Native material
    String extInfo;

    @Deprecated
    String scale;//1.2版本新增 广告尺寸
    @Deprecated
    String advSeatType;//1.2版本新增 广告位类型 通过这个判断使用老版本还是新版本广告样式
    String materialStyle;//1.2版本新增 广告样式

    //1.3.0版本新增
    Double firstPrice;//一价
    Double secondPrice;//二价
    Integer commissionRatio;//分成系数

    //1.4.0版本新增
    Integer dspType;//dsp类型：1-b2、2-adx
    String adm; // 140新增adm广告片段
    List<String> scales;//140新增adm广告尺寸数组
    String applicationTitle;//140新增应用logo

    //曝光上报 二价曝光
    public String getNewPrice() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("_first_price=");
            stringBuilder.append(firstPrice);
            stringBuilder.append("&");
            stringBuilder.append("_second_price=");
            stringBuilder.append(secondPrice);
            stringBuilder.append("&");
            stringBuilder.append("_ratio=");
            stringBuilder.append(commissionRatio);
            AdLogUtil.Log().d(AdLogUtil.SECOND_PRICE_TAG, "*----> AdsDTO getNewPrice() = " + stringBuilder.toString());
            //AES加密
            byte[] bytes = AESUtils.encrypt(stringBuilder.toString()).getBytes();
            //Base64 加密
            return Base64.encodeToString(bytes, Base64.NO_WRAP);
        } catch (Exception e) {
            AdLogUtil.Log().e("AdsDTO getNewPrice() error = " + Log.getStackTraceString(e));
        }
        return "";
    }

    //点击上报 二价曝光
    public String getNewPrice_Click() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("p1=");
            stringBuilder.append(firstPrice);
            stringBuilder.append("&");
            stringBuilder.append("p2=");
            stringBuilder.append(secondPrice);
            stringBuilder.append("&");
            stringBuilder.append("t=");
            stringBuilder.append(commissionRatio);
            AdLogUtil.Log().d(AdLogUtil.SECOND_PRICE_TAG, "*----> AdsDTO getNewPrice_Click() = " + stringBuilder.toString());
            return stringBuilder.toString();
        } catch (Exception e) {
            AdLogUtil.Log().e("AdsDTO getNewPrice_Click() error = " + Log.getStackTraceString(e));
        }
        return "";
    }

    //曝光，点击上报 是否安装推广应用1.非下载类广告 2. 已安装目标下载应用 3.未安装目标下载应用
    public int getInstallApk() {
        if (TextUtils.isEmpty(packageName)) {
            return Constants.INSTALL_APK_STATUS.NON_DOWNLOAD_AD;
        }
        if (CoreUtil.getContext() == null) {
            return Constants.INSTALL_APK_STATUS.ERROR_SITUATION;
        }
        try {
            PackageInfo packageinfo = CoreUtil.getContext().getPackageManager().getPackageInfo(packageName, 0);
            if (packageinfo == null) {
                return Constants.INSTALL_APK_STATUS.DOWNLOAD_APP_NOT_INSTALLED;
            }
            return Constants.INSTALL_APK_STATUS.DOWNLOAD_APP_INSTALLED;
        } catch (Exception e) {
            if (Build.VERSION.SDK_INT >= 30) {
                return Constants.INSTALL_APK_STATUS.ERROR_SITUATION;
            } else {
                return Constants.INSTALL_APK_STATUS.DOWNLOAD_APP_NOT_INSTALLED;
            }
        }

    }

    public String getApplicationTitle() {
        return applicationTitle;
    }

    public void setApplicationTitle(String applicationTitle) {
        this.applicationTitle = applicationTitle;
    }

    public Integer getDspType() {
        return dspType == null ? 1 : dspType;
    }

    public Double getFirstPrice() {
        return firstPrice == null ? 0 : firstPrice;
    }

    public void setSecondPrice(double secondPrice) {
        AdLogUtil.Log().d(AdLogUtil.SECOND_PRICE_TAG, "new secondPrice" + secondPrice + "old secondPrice" + this.secondPrice);
        //高于旧二价，低于一价，才赋值
        if (secondPrice > this.getSecondPrice() && secondPrice <= this.getFirstPrice()) {
            this.secondPrice = secondPrice;
        }
        //adx 扣费价格=MAX（ADX还原次高价，Admob出价，Fan出价）+1美分
        if (getDspType() == 2) {
            this.secondPrice = this.secondPrice + 1;
        }
    }

    public Double getSecondPrice() {
        return secondPrice == null ? 0 : secondPrice;
    }

    public Integer getId() {
        return id == null ? 0 : id;
    }

    public Long getAdvertiserId() {
        return advertiserId == null ? 0 : advertiserId;
    }

    public Long getPlanId() {
        return planId == null ? 0 : planId;
    }

    public Long getAdGroupId() {
        return adGroupId == null ? 0 : adGroupId;
    }

    public Long getAdCreativeId() {
        return adCreativeId == null ? 0 : adCreativeId;
    }

    public String getPackageName() {
        return null == packageName ? "" : packageName;
    }

    public String getClickUrl() {
        return null == clickUrl ? "" : clickUrl;
    }

    public ArrayList<String> getStoreDeeplink() {
        return storeDeeplink;
    }

    public void setStoreDeeplink(ArrayList<String> storeDeeplink) {
        this.storeDeeplink = storeDeeplink;
    }

    public String getDeepLinkUrl() {
        return deepLinkUrl;
    }

    public List<String> getShowTrackingUrls() {
        return showTrackingUrls;
    }

    public String getLogoUrl(){
        return nativeObject==null?"":nativeObject.getLogoUrl();
    }

    public String getAdChoiceImageUrl() {
        return null == adChoiceImageUrl ? "" : adChoiceImageUrl;
    }

    public String getAdChoiceClickUrl() {
        return null == adChoiceClickUrl ? "" : adChoiceClickUrl;
    }

    public String getAdChoiceLegalText() {
        return null == adChoiceLegalText ? "" : adChoiceLegalText;
    }

    public String getDefaultAdExpirationTime() {
        return null == defaultAdExpirationTime ? "" : defaultAdExpirationTime;
    }

    public Integer getDefaultAdShowCount() {
        return defaultAdShowCount == null ? 0 : defaultAdShowCount;
    }

    public void setDefaultAdShowCount(Integer defaultAdShowCount) {
        this.defaultAdShowCount = defaultAdShowCount;
    }

    public NativeBean getNativeObject() {
        return nativeObject;
    }

    public String getPlanType() {
        return null == planType ? "" : planType;
    }

    public String getShowTrackingSecretKey() {
        return null == showTrackingSecretKey ? "" : showTrackingSecretKey;
    }

    public ArrayList<String> getClickTrackingUrls() {
        return clickTrackingUrls;
    }

    public String getImageUrl() {
        return null == imageUrl ? "" : imageUrl;
    }

    public Integer getImageWidth() {
        return null == imageWidth ? 0 : imageWidth;
    }

    public Integer getImageHeight() {
        return null == imageHeight ? 0 : imageHeight;
    }

    public String getExtInfo() {
        return null == extInfo ? "" : extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public String getScale() {
        return scale;
    }

    public String getAdvSeatType() {
        return advSeatType;
    }

    public String getMaterialStyle() {
        return null == materialStyle ? "" : materialStyle;
    }

    /**
     * 区分普通广告还是pslink广告
     * 1. 非pslink广告
     * 2. pslink广告"
     */
    public int getIsPslinkAd() {
        if (storeDeeplink != null && storeDeeplink.toString().contains(PsRequestManager.CLICKURLS_PS_FLAG)) {
            return Constants.IS_PSLINK_AD.IS_PSLINK_AD;
        }
        return Constants.IS_PSLINK_AD.NO_IS_PSLINK_AD;
    }

    public List<AbTestDTO> getAbTest() {
        return abTest;
    }

    public Integer getCacheTime() {
        return cacheTime == null ? 0 : cacheTime;
    }

    public String getAdm() {
        return adm;
    }

    public void setAdm(String adm) {
        this.adm = adm;
    }

    public List<String> getScales() {
        return scales;
    }

    public void setScales(List<String> scales) {
        this.scales = scales;
    }

    /**
     * 获取 图片的地址 ================================================================================
     *
     * @return
     */
    public String getAdImgUrl() {
        String url = "";
        if (null != nativeObject && null != nativeObject.getMainImages() && nativeObject.getMainImages().size() > 0) {
            url = nativeObject.getMainImages().get(0).getUrl();
        }
        return url;
    }

    public Integer getAdImageWidth() {
        Integer width = 0;
        if (null != nativeObject && null != nativeObject.getMainImages() && nativeObject.getMainImages().size() > 0) {
            width = nativeObject.getMainImages().get(0).getWidth();
        }
        return width;
    }

    public Integer getAdImageHeight() {
        Integer height = 0;
        if (null != nativeObject && null != nativeObject.getMainImages() && nativeObject.getMainImages().size() > 0) {
            height = nativeObject.getMainImages().get(0).getHeight();
        }
        return height;
    }

    public void setCacheTime(Integer cacheTime) {
        this.cacheTime = cacheTime;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setAdvertiserId(Long advertiserId) {
        this.advertiserId = advertiserId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public void setPlanType(String planType) {
        this.planType = planType;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public void setAdCreativeId(Long adCreativeId) {
        this.adCreativeId = adCreativeId;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setClickUrl(String clickUrl) {
        this.clickUrl = clickUrl;
    }

    public void setDeepLinkUrl(String deepLinkUrl) {
        this.deepLinkUrl = deepLinkUrl;
    }

    public void setShowTrackingUrls(ArrayList<String> showTrackingUrls) {
        this.showTrackingUrls = showTrackingUrls;
    }

    public void setShowTrackingSecretKey(String showTrackingSecretKey) {
        this.showTrackingSecretKey = showTrackingSecretKey;
    }

    public void setClickTrackingUrls(ArrayList<String> clickTrackingUrls) {
        this.clickTrackingUrls = clickTrackingUrls;
    }

    public void setAdChoiceImageUrl(String adChoiceImageUrl) {
        this.adChoiceImageUrl = adChoiceImageUrl;
    }

    public void setAdChoiceClickUrl(String adChoiceClickUrl) {
        this.adChoiceClickUrl = adChoiceClickUrl;
    }

    public void setAdChoiceLegalText(String adChoiceLegalText) {
        this.adChoiceLegalText = adChoiceLegalText;
    }

    public void setDefaultAdExpirationTime(String defaultAdExpirationTime) {
        this.defaultAdExpirationTime = defaultAdExpirationTime;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setImageWidth(Integer imageWidth) {
        this.imageWidth = imageWidth;
    }

    public void setImageHeight(Integer imageHeight) {
        this.imageHeight = imageHeight;
    }

    public void setNativeObject(NativeBean nativeObject) {
        this.nativeObject = nativeObject;
    }

    public void setScale(String scale) {
        this.scale = scale;
    }

    public void setAdvSeatType(String advSeatType) {
        this.advSeatType = advSeatType;
    }

    public void setMaterialStyle(String materialStyle) {
        this.materialStyle = materialStyle;
    }

    public void setAbTest(List<AbTestDTO> abTest) {
        this.abTest = abTest;
    }

}

