/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.athena;

import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import com.cloud.hisavana.sdk.common.athena.AthenaTrackerInvoker;
import com.cloud.hisavana.sdk.common.athena.AthenaUtil;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdPsResponseBody;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import java.util.List;

public class AthenaTracker {
    public static final int DOWNLOAD_WAY_HTTP_URL_CONNECTION = 1;
    public static final int DOWNLOAD_WAY_OKHTTP = 2;
    public static final int M_STATUS_STAR = 1;
    public static final int M_STATUS_SUCCESS = 2;
    public static final int M_STATUS_ERROR = 3;
    public static final int M_TYPE_LOGO = 1;
    public static final int M_TYPE_LARGE_IMG = 2;
    public static final int M_TYPE_AD_CHOICE_VIEW = 3;
    public static final int M_TYPE_AD_PS = 4;
    public static Handler handler;
    public static HandlerThread handlerThread;

    private static synchronized void initHandler() {
        if (handler == null) {
            handlerThread = AthenaUtil.getHanderThread();
            AthenaUtil.start();
            handler = new Handler(handlerThread.getLooper());
            AdLogUtil.Log().d("ssp", "AthenaTracker initHandlerThread");
        }
    }

    public static Bundle getBundle(Bundle bundle) {
        return AthenaTrackerInvoker.getBundle(bundle);
    }

    public static void trackInNewThread(Runnable runnable) {
        AthenaTracker.initHandler();
        handler.post(runnable);
    }

    public static void trackShow(final AdsDTO info) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackShow(info);
            }
        });
    }

    public static void trackDeeplink(final AdsDTO info) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackDeeplink(info);
            }
        });
    }

    public static void trackImageDownload(final AdsDTO info, final int requestType, final int downloadWay, final int mStatus, final int errorCode, final int mType, final String cdn, final long timeConsuming, final int fileSize) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackImageDownload(info, requestType, downloadWay, mStatus, errorCode, mType, cdn, timeConsuming, fileSize);
            }
        });
    }

    public static void trackImageDownload(AdsDTO info, int download_way, int m_status, String errorcode, int m_type) {
        AthenaTracker.trackImageDownload(info, 1, download_way, m_status, 1, m_type, "", 1L, 1);
    }

    public static void trackSspRequest(final AdxImpBean info) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspRequest(info);
            }
        });
    }

    public static void trackSspReturn(final AdsDTO info, final TaErrorCode adError, final AdxImpBean adxImpBean) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspReturn(info, adError, adxImpBean);
            }
        });
    }

    public static void trackSspRequestPs(final AdsDTO info, final String gplink) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspRequestPs(info, gplink);
            }
        });
    }

    public static void trackSspReturnPs(final AdsDTO info, final List<String> gplinks, final List<AdPsResponseBody.PsLinkListDTO> psLinkListDTOS, final TaErrorCode adError) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspReturnPs(info, gplinks, psLinkListDTOS, adError);
            }
        });
    }

    public static void trackPsPopupImp(final AdsDTO info, final List<String> gplinks, final List<AdPsResponseBody.PsLinkListDTO> psLinkListDTOS) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackPsPopupImp(info, gplinks, psLinkListDTOS);
            }
        });
    }

    public static void trackPsPopupClick(final AdsDTO info, final int clickContentType) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackPsPopupClick(info, clickContentType);
            }
        });
    }

    public static void trackWebViewRedirect(final AdsDTO info) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackWebViewRedirect(info);
            }
        });
    }

    public static void trackWebViewClick(final AdsDTO info, final Bundle params) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackWebViewClick(info, params);
            }
        });
    }

    public static void trackWebViewComplete(final AdsDTO info, final Bundle params) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackWebViewComplete(info, params);
            }
        });
    }
}

