/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.athena;

import android.os.Bundle;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.athena.PostConstant;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.gsonutil.GsonUtil;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.DeviceUtil;
import com.cloud.hisavana.sdk.common.util.GPSTracker;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdPsResponseBody;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.transsion.athenacust.AthenaCust;
import java.util.List;

public class AthenaTrackerInvoker {
    public static Bundle getBundle(Bundle bundle) {
        long start = 0L;
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("session_id", PostConstant.getSessionId());
        bundle.putString("sdk_version", PostConstant.getSdkVersion());
        bundle.putString("user_agent", PostConstant.getUserAgent());
        bundle.putInt("type", PostConstant.getType());
        bundle.putString("make", PostConstant.getMake());
        bundle.putString("ostype", "Android");
        bundle.putString("imei_sha1", PostConstant.getImeiSha1());
        bundle.putString("imei_md5", PostConstant.getImeiMd5());
        bundle.putString("androidId_sha1", PostConstant.getAndroidIdSha1());
        bundle.putString("androidId_md5", PostConstant.getAndroidIdMd5());
        bundle.putInt("screen_width", PostConstant.getScreenWidth());
        bundle.putInt("screen_height", PostConstant.getScreenHeight());
        bundle.putInt("screen_density", PostConstant.getScreenDensity());
        bundle.putString("base_station", DeviceUtil.getGsmCellLocation());
        bundle.putDouble("latitude", GPSTracker.getLatitude());
        bundle.putDouble("longitude", GPSTracker.getLongitude());
        bundle.putLong("coordtime", GPSTracker.getCoordTime());
        bundle.putString("imsi", PostConstant.getImsi());
        bundle.putString("mac", PostConstant.getMac());
        return bundle;
    }

    public static void trackShow(AdsDTO info) {
        AdLogUtil.Log().d("ssp", "currentThread().getId()" + Thread.currentThread().getId());
        Bundle bundle = new Bundle();
        bundle.putDouble("price", info.getFirstPrice().doubleValue());
        bundle.putString("new_price", info.getNewPrice());
        bundle.putInt("popularize_app_install_status", info.getInstallApk());
        bundle.putLong("show_duration", info.getActualShowTime().longValue());
        bundle.putString("show_area", info.getShowArea());
        bundle.putLong("show_report_time_type", (long)info.getShowReportTimeType().intValue());
        bundle.putString("deep_link_url", info.getDeepLinkUrl());
        bundle.putInt("is_pslink_ad", info.getIsPslinkAd());
        bundle.putInt("is_adm_ad", TextUtils.isEmpty((CharSequence)info.getAdm()) ? 1 : 2);
        new AthenaCust("ad_ssp_show", 2411).trackCommon(AthenaTrackerInvoker.fillAdParamsToBundleForShowAndDeeplink(info, bundle), null).submit();
    }

    public static void trackDeeplink(AdsDTO info) {
        Bundle bundle = new Bundle();
        bundle.putString("deep_link_url", info.getDeepLinkUrlFirst());
        bundle.putInt("called_url_type", info.getCalledUrlType());
        bundle.putString("app_name", info.getPslinkAppName());
        new AthenaCust("deeplink", 2411).trackCommon(AthenaTrackerInvoker.fillAdParamsToBundleForShowAndDeeplink(info, bundle), null).submit();
    }

    private static Bundle fillAdParamsToBundleForShowAndDeeplink(AdsDTO info, Bundle params) {
        Bundle bundle = AthenaTrackerInvoker.getBundle(params);
        bundle.putString("request_id", info.getRid());
        bundle.putString("code_seat_id", info.getCodeSeatId());
        bundle.putInt("code_seat_type", info.getCodeSeatType().intValue());
        bundle.putInt("cache_time", info.getCacheTime().intValue());
        bundle.putInt("id", info.getId().intValue());
        bundle.putLong("advertiser_id", info.getAdvertiserId().longValue());
        bundle.putLong("plan_id", info.getPlanId().longValue());
        bundle.putLong("ad_group_id", info.getAdGroupId().longValue());
        bundle.putLong("ad_creative_id", info.getAdCreativeId().longValue());
        bundle.putString("package_name", info.getPackageName());
        bundle.putString("click_url", info.getClickUrl());
        bundle.putString("tracking_secret_key", info.getShowTrackingSecretKey());
        bundle.putString("default_ad_expiration_time", info.getDefaultAdExpirationTime());
        bundle.putInt("default_ad_show_count", info.getDefaultAdShowCount().intValue());
        bundle.putInt("is_default_ad_first_show", info.getIsDefaultAdFirstShow().intValue());
        bundle.putString("image_url", info.getAdImgUrl());
        bundle.putInt("image_width", info.getAdImageWidth().intValue());
        bundle.putInt("image_height", info.getAdImageHeight().intValue());
        if (info.getNativeObject() != null) {
            bundle.putString("version", info.getNativeObject().getVersion());
            bundle.putInt("rating", info.getNativeObject().getRating().intValue());
            bundle.putString("title_text", info.getNativeObject().getTitleTxt());
            bundle.putString("descript_text", info.getNativeObject().getDescriptionTxt());
            bundle.putString("button_text", info.getNativeObject().getButtonTxt(info.getInstallApk()));
            if (info.getNativeObject().getLogo() != null) {
                bundle.putString("logo_url", info.getNativeObject().getLogoUrl());
                bundle.putInt("logo_width", info.getNativeObject().getLogo().getWidth().intValue());
                bundle.putInt("logo_height", info.getNativeObject().getLogo().getHeight().intValue());
            }
            if (info.getNativeObject().getMainImages() != null && info.getNativeObject().getMainImages().size() > 0) {
                bundle.putString("main_image_url", info.getNativeObject().getMainImages().get(0).getUrl());
                bundle.putInt("main_image_width", info.getNativeObject().getMainImages().get(0).getWidth().intValue());
                bundle.putInt("main_image_height", info.getNativeObject().getMainImages().get(0).getHeight().intValue());
            }
        }
        bundle.putLong("login_time", System.currentTimeMillis());
        bundle.putInt("is_default_ad", info.getIsDefaultAd().intValue());
        bundle.putInt("actual_show_rate", info.getActualShowRate().intValue());
        bundle.putLong("show_ts", System.currentTimeMillis());
        bundle.putInt("is_effective_show", info.getIsEffectiveShow().intValue());
        bundle.putString("app_id", SspAd.AppId);
        if (info.getStoreDeeplink() != null && info.getStoreDeeplink().size() > 0) {
            bundle.putString("click_urls", info.getStoreDeeplink().toString());
        }
        bundle.putInt("is_test_request", SspAd.isTestRequest() ? 1 : 0);
        if (info.getAbTest() != null) {
            bundle.putString("abTest", GsonUtil.toJson(info.getAbTest()));
        }
        bundle.putString("extInfo", info.getExtInfo());
        if (info.getImpBeanRequest() != null) {
            bundle.putInt("request_type", info.getImpBeanRequest().requestType);
        }
        return bundle;
    }

    public static void trackImageDownload(AdsDTO info, int requestType, int downloadWay, int mStatus, int errorCode, int mType, String cdn, long timeConsuming, int fileSize) {
        if (null == info) {
            return;
        }
        Bundle bundle = AthenaTrackerInvoker.getBundle(null);
        bundle.putString("request_id", info.getRid());
        bundle.putString("code_seat_id", info.getCodeSeatId());
        bundle.putInt("code_seat_type", info.getCodeSeatType().intValue());
        bundle.putLong("advertiser_id", info.getAdvertiserId().longValue());
        bundle.putLong("plan_id", info.getPlanId().longValue());
        bundle.putLong("ad_group_id", info.getAdGroupId().longValue());
        bundle.putLong("ad_creative_id", info.getAdCreativeId().longValue());
        bundle.putString("package_name", info.getPackageName());
        String url = "";
        switch (mType) {
            case 1: {
                url = info.getLogoUrl();
                break;
            }
            case 3: {
                url = info.getAdChoiceImageUrl();
                break;
            }
            default: {
                url = info.getAdImgUrl();
            }
        }
        bundle.putString("image_url", url);
        bundle.putInt("image_width", info.getAdImageWidth().intValue());
        bundle.putInt("image_height", info.getAdImageHeight().intValue());
        bundle.putLong("login_time", System.currentTimeMillis());
        bundle.putInt("is_default_ad", info.getIsDefaultAd().intValue());
        bundle.putInt("download_way ", downloadWay);
        bundle.putInt("m_status", mStatus);
        bundle.putInt("error_code", errorCode);
        bundle.putInt("m_type", mType);
        bundle.putString("x_response_cdn", cdn);
        bundle.putInt("request_type", requestType);
        bundle.putLong("time_consuming", timeConsuming);
        bundle.putInt("file_size", fileSize);
        bundle.putInt("is_adm_ad", TextUtils.isEmpty((CharSequence)info.getAdm()) ? 1 : 2);
        new AthenaCust("material_load", 2411).trackCommon(bundle, null).submit();
    }

    public static void trackSspRequest(AdxImpBean info) {
        Bundle bundle = AthenaTrackerInvoker.getBundle(null);
        bundle.putInt("request_type", info.requestType);
        bundle.putLong("request_ts", info.getRequestTs().longValue());
        bundle.putString("request_id", info.requestId);
        bundle.putInt("ad_type", info.adt);
        bundle.putString("app_id", SspAd.AppId);
        bundle.putString("code_seat_id", info.pmid);
        bundle.putInt("ad_count", info.mAdCount);
        bundle.putInt("is_retreatad", 0);
        bundle.putInt("is_default_ad", info.defaultAd ? 1 : 0);
        if (bundle != null) {
            new AthenaCust("ad_ssp_request", 2411).trackCommon(bundle, null).submit();
        }
    }

    public static void trackSspReturn(AdsDTO info, TaErrorCode adError, AdxImpBean adxImpBean) {
        Bundle bundle = AthenaTrackerInvoker.getBundle(null);
        if (info != null && info.getImpBeanRequest() != null && adxImpBean == null) {
            adxImpBean = info.getImpBeanRequest();
            bundle.putInt("is_pslink_ad", info.getIsPslinkAd());
        }
        if (adxImpBean != null) {
            bundle.putInt("request_type", adxImpBean.requestType);
            bundle.putLong("request_ts", adxImpBean.getRequestTs().longValue());
            bundle.putString("request_id", adxImpBean.requestId);
            bundle.putInt("ad_type", adxImpBean.adt);
            bundle.putString("code_seat_id", adxImpBean.pmid);
            bundle.putInt("ad_count", adxImpBean.mAdCount);
            bundle.putInt("is_default_ad", adxImpBean.defaultAd ? 1 : 0);
            if (adxImpBean.getRequestTs() != 0L) {
                bundle.putInt("return_time", (int)(System.currentTimeMillis() - adxImpBean.getRequestTs()));
            }
            bundle.putInt("is_timeout", adxImpBean.isTimeOut);
        }
        bundle.putString("app_id", SspAd.AppId);
        bundle.putLong("return_ts", System.currentTimeMillis());
        if (adError != null) {
            bundle.putString("error_code", adError.getErrorCode() + "");
            bundle.putString("error_message", adError.getErrorMessage());
        }
        if (info != null) {
            bundle.putDouble("bidding_price", info.getFirstPrice().doubleValue());
            bundle.putLong("advertiser_id", info.getAdvertiserId().longValue());
            bundle.putLong("plan_id", info.getPlanId().longValue());
            bundle.putLong("ad_group_id", info.getAdGroupId().longValue());
            bundle.putLong("ad_creative_id", info.getAdCreativeId().longValue());
            bundle.putString("package_name", info.getPackageName());
            bundle.putString("image_url", info.getAdImgUrl());
            bundle.putInt("image_width", info.getAdImageWidth().intValue());
            bundle.putInt("image_height", info.getAdImageHeight().intValue());
            bundle.putString("default_ad_expiration_time", info.getDefaultAdExpirationTime());
            bundle.putInt("default_ad_show_count", info.getDefaultAdShowCount().intValue());
            bundle.putString("material_style", info.getMaterialStyle());
            if (info.getNativeObject() != null) {
                String str = GsonUtil.toJson(info.getNativeObject());
                bundle.putString("ad_material_info_list", str);
            }
            if (info.getStoreDeeplink() != null && info.getStoreDeeplink().size() > 0) {
                bundle.putString("click_urls", info.getStoreDeeplink().toString());
            }
            bundle.putInt("is_adm_ad", TextUtils.isEmpty((CharSequence)info.getAdm()) ? 1 : 2);
        }
        if (bundle != null) {
            new AthenaCust("ad_ssp_return", 2411).trackCommon(bundle, null).submit();
        }
    }

    public static void trackSspRequestPs(AdsDTO info, String gplink) {
        Bundle bundle = AthenaTrackerInvoker.getBundle(null);
        AdxImpBean adxImpBean = null;
        if (info != null && info.getImpBeanRequest() != null) {
            adxImpBean = info.getImpBeanRequest();
        }
        if (adxImpBean == null) {
            return;
        }
        bundle.putString("gplink", gplink);
        bundle.putString("request_id", adxImpBean.requestId);
        info.setRequestPsTs(System.currentTimeMillis());
        bundle.putLong("request_ts", info.getRequestPsTs());
        bundle.putString("app_id", SspAd.AppId);
        bundle.putString("code_seat_id", adxImpBean.pmid);
        if (bundle != null) {
            new AthenaCust("ad_ssp_request_ps_material", 2411).trackCommon(bundle, null).submit();
        }
    }

    public static void trackSspReturnPs(AdsDTO info, List<String> gplinks, List<AdPsResponseBody.PsLinkListDTO> psLinkListDTOS, TaErrorCode adError) {
        Bundle bundle = AthenaTrackerInvoker.getBundle(null);
        AdxImpBean adxImpBean = null;
        if (info != null && info.getImpBeanRequest() != null) {
            adxImpBean = info.getImpBeanRequest();
        }
        if (adxImpBean == null) {
            return;
        }
        bundle.putString("request_id", adxImpBean.requestId);
        bundle.putString("gplink_list", GsonUtil.toJson(gplinks));
        bundle.putString("pslink_list", GsonUtil.toJson(psLinkListDTOS));
        bundle.putLong("request_ts", info.getRequestPsTs());
        info.setReturnPsTs(System.currentTimeMillis());
        bundle.putLong("return_ts", info.getReturnPsTs());
        bundle.putString("app_id", SspAd.AppId);
        bundle.putString("code_seat_id", adxImpBean.pmid);
        if (adError != null) {
            bundle.putString("error_code", adError.getErrorCode() + "");
            bundle.putString("error_message", adError.getErrorMessage());
        }
        if (bundle != null) {
            new AthenaCust("ad_ssp_return_ps_material", 2411).trackCommon(bundle, null).submit();
        }
    }

    public static void trackPsPopupImp(AdsDTO info, List<String> gplinks, List<AdPsResponseBody.PsLinkListDTO> psLinkListDTOS) {
        Bundle bundle = AthenaTrackerInvoker.getBundle(null);
        AdxImpBean adxImpBean = null;
        if (info != null && info.getImpBeanRequest() != null && adxImpBean == null) {
            adxImpBean = info.getImpBeanRequest();
        }
        if (adxImpBean == null) {
            return;
        }
        bundle.putString("request_id", adxImpBean.requestId);
        bundle.putString("gplink_list", GsonUtil.toJson(gplinks));
        bundle.putString("pslink_list", GsonUtil.toJson(psLinkListDTOS));
        bundle.putLong("request_ts", info.getRequestPsTs());
        bundle.putLong("return_ts", info.getReturnPsTs());
        bundle.putString("app_id", SspAd.AppId);
        bundle.putString("code_seat_id", adxImpBean.pmid);
        bundle.putLong("popup_imp_ts", System.currentTimeMillis());
        if (bundle != null) {
            new AthenaCust("popup_imp", 2411).trackCommon(bundle, null).submit();
        }
    }

    public static void trackPsPopupClick(AdsDTO info, int clickContentType) {
        Bundle bundle = AthenaTrackerInvoker.getBundle(null);
        AdxImpBean adxImpBean = null;
        if (info != null && info.getImpBeanRequest() != null) {
            adxImpBean = info.getImpBeanRequest();
        }
        if (adxImpBean == null) {
            return;
        }
        bundle.putString("request_id", adxImpBean.requestId);
        bundle.putString("app_id", SspAd.AppId);
        bundle.putString("code_seat_id", adxImpBean.pmid);
        bundle.putLong("popup_click_ts", System.currentTimeMillis());
        bundle.putInt("click_content_type", clickContentType);
        if (bundle != null) {
            new AthenaCust("popup_click", 2411).trackCommon(bundle, null).submit();
        }
    }

    public static void trackWebViewRedirect(AdsDTO info) {
        if (info == null) {
            return;
        }
        AdxImpBean adxImpBean = null;
        if (info != null && info.getImpBeanRequest() != null) {
            adxImpBean = info.getImpBeanRequest();
        }
        if (adxImpBean == null) {
            return;
        }
        Bundle bundle = AthenaTrackerInvoker.getBundle(null);
        bundle.putString("request_id", adxImpBean.requestId);
        bundle.putInt("request_type", adxImpBean.requestType);
        bundle.putLong("ad_creative_id", info.getAdCreativeId().longValue());
        bundle.putLong("advertiser_id", info.getAdvertiserId().longValue());
        bundle.putString("code_seat_id", adxImpBean.pmid);
        bundle.putInt("code_seat_type", info.getCodeSeatType().intValue());
        bundle.putString("web_url", info.getClickUrl());
        if (info.getClickUrlTs() != 0L) {
            bundle.putInt("web_duration", (int)(System.currentTimeMillis() - info.getClickUrlTs()));
        }
        if (bundle != null) {
            new AthenaCust("ad_web_callback", 2411).trackCommon(bundle, null).submit();
        }
    }

    public static void trackWebViewClick(AdsDTO info, Bundle params) {
        Bundle bundle = AthenaTrackerInvoker.getBundle(params);
        if (info != null) {
            bundle.putString("request_id", info.getRid());
            bundle.putInt("request_type", info.getRequestType());
            bundle.putString("ad_creative_id", info.getAdCreativeId() + "");
            bundle.putString("advertiser_id", info.getAdvertiserId() + "");
            bundle.putString("code_seat_id", info.getCodeSeatId());
            bundle.putInt("code_seat_type", info.getCodeSeatType().intValue());
        }
        if (bundle != null) {
            new AthenaCust("ad_web_click", 2411).trackCommon(bundle, null).submit();
        }
    }

    public static void trackWebViewComplete(AdsDTO info, Bundle params) {
        Bundle bundle = AthenaTrackerInvoker.getBundle(params);
        if (info != null) {
            bundle.putString("request_id", info.getRid());
            bundle.putInt("request_type", info.getRequestType());
            bundle.putString("ad_creative_id", info.getAdCreativeId() + "");
            bundle.putString("advertiser_id", info.getAdvertiserId() + "");
            bundle.putString("code_seat_id", info.getCodeSeatId());
            bundle.putInt("code_seat_type", info.getCodeSeatType().intValue());
        }
        if (bundle != null) {
            new AthenaCust("ad_web_complete", 2411).trackCommon(bundle, null).submit();
        }
    }
}

