/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.widget.webview;

import android.os.MessageQueue;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.widget.webview.WebAssetsManager;
import com.cloud.hisavana.sdk.common.widget.webview.WebUrlData;
import com.transsion.core.pool.TranssionPoolManager;
import java.io.File;
import java.util.List;

public class AssetCleanTask
implements MessageQueue.IdleHandler {
    private final List<WebUrlData> mWebDataList;

    public AssetCleanTask(List<WebUrlData> webDataList) {
        this.mWebDataList = webDataList;
    }

    public boolean queueIdle() {
        AdLogUtil.Log().d("webview--", "AssetCleanTask start clean when idle");
        TranssionPoolManager.getInstance().addTask(new Runnable(){

            @Override
            public void run() {
                try {
                    String[] list;
                    String webAssetPath = WebAssetsManager.getWebAssetPath();
                    if (TextUtils.isEmpty((CharSequence)webAssetPath) || AssetCleanTask.this.mWebDataList == null || AssetCleanTask.this.mWebDataList.isEmpty()) {
                        return;
                    }
                    File file = new File(webAssetPath);
                    if (file.isDirectory() && (list = file.list()) != null && list.length > 0) {
                        int needDeleteNum = 0;
                        for (int i2 = 0; i2 < list.length; ++i2) {
                            String fileName = list[i2];
                            boolean exist = false;
                            for (WebUrlData webUrlData : AssetCleanTask.this.mWebDataList) {
                                if (webUrlData == null || TextUtils.isEmpty((CharSequence)webUrlData.getUrl())) continue;
                                String url = webUrlData.getUrl();
                                if (TextUtils.equals((CharSequence)WebAssetsManager.getWebAssetName(url), (CharSequence)fileName)) {
                                    exist = true;
                                    break;
                                }
                                exist = false;
                            }
                            if (exist) continue;
                            ++needDeleteNum;
                            boolean delete = WebAssetsManager.deleteWebAsset(webAssetPath + File.separator + fileName);
                            if (!delete) continue;
                        }
                        AdLogUtil.Log().d("webview--", "AssetCleanTask current time delete num = " + needDeleteNum);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
        return false;
    }
}

