/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.widget.webview;

import android.content.Context;
import android.os.MessageQueue;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.widget.webview.WebAssetsManager;
import com.cloud.hisavana.sdk.common.widget.webview.WebUrlData;
import com.transsion.core.CoreUtil;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.http.HttpClient;
import com.transsion.http.builder.DownloadRequestBuilder;
import com.transsion.http.impl.HttpCallbackImpl;
import com.transsion.http.impl.IHttpCallback;
import java.util.concurrent.atomic.AtomicBoolean;

public class IdleDownloadTask
implements MessageQueue.IdleHandler {
    private final WebUrlData mWebData;
    private OnDownloadCallback mCallback;
    private AtomicBoolean called = new AtomicBoolean(false);

    public IdleDownloadTask(WebUrlData webData) {
        this.mWebData = webData;
    }

    public IdleDownloadTask(WebUrlData webData, OnDownloadCallback callback) {
        this.mWebData = webData;
        this.mCallback = callback;
    }

    public boolean queueIdle() {
        this.download(this.mWebData);
        return false;
    }

    private void onSuccessFinal(String url) {
        if (this.mCallback != null && this.called.compareAndSet(false, true)) {
            this.mCallback.onComplete(url);
        }
    }

    private void download(final WebUrlData webData) {
        if (webData == null || TextUtils.isEmpty((CharSequence)webData.getUrl())) {
            return;
        }
        if (WebAssetsManager.checkWebAssetExist(webData.getUrl())) {
            return;
        }
        final long start = System.currentTimeMillis();
        ((DownloadRequestBuilder)((DownloadRequestBuilder)((DownloadRequestBuilder)((DownloadRequestBuilder)HttpClient.download((Context)CoreUtil.getContext()).log(false)).pathname("xxxx").connectTimeout(20000)).readTimeout(20000)).url(webData.getUrl())).build().execute((IHttpCallback)new HttpCallbackImpl(true){

            public void onSuccess(int statusCode, final byte[] data) {
                TranssionPoolManager.getInstance().addTask(new Runnable(){

                    @Override
                    public void run() {
                        if (webData != null) {
                            String assetPath = WebAssetsManager.saveAssetToFile(data, webData.getUrl());
                            AdLogUtil.Log().d("webview--", "IdleDownloadTask save assetPath = " + assetPath + " time = " + (System.currentTimeMillis() - start));
                        }
                        IdleDownloadTask.this.onSuccessFinal(webData.getUrl());
                    }
                });
            }

            public void onFailure(int statusCode, byte[] bytes, Throwable throwable) {
                AdLogUtil.Log().d("webview--", "IdleDownloadTask download fail url = " + webData.getUrl());
                if (IdleDownloadTask.this.mCallback != null && throwable != null) {
                    IdleDownloadTask.this.mCallback.onFail(statusCode, throwable.getMessage());
                }
            }

            public void onSuccess(int statusCode, byte[] responseBody, String filePath) {
                AdLogUtil.Log().d("webview--", "IdleDownloadTask download success url = " + webData.getUrl() + " path = " + filePath);
                IdleDownloadTask.this.onSuccessFinal(webData.getUrl());
            }
        });
    }

    public static interface OnDownloadCallback {
        public void onComplete(String var1);

        public void onFail(int var1, String var2);
    }
}

