/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.widget.webview;

import android.net.Uri;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.common.util.FileUtil;
import com.cloud.hisavana.sdk.common.util.MD5Utils;
import com.transsion.core.CoreUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class WebAssetsManager {
    private static final String SSP_WEB_ASSETS = "ssp_web_assets";

    private WebAssetsManager() {
    }

    public static boolean checkWebAssetExist(String url) {
        try {
            return new File(WebAssetsManager.getWebAssetFilePath(url)).exists();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static String saveAssetToFile(byte[] bytes, String url) {
        try {
            String urlWithoutScheme = WebAssetsManager.subStringScheme(url);
            File cacheDir = new File(WebAssetsManager.getWebAssetPath());
            String md5Name = MD5Utils.toMd5(urlWithoutScheme);
            FileUtil.saveBytesToFile(cacheDir, bytes, md5Name);
            return WebAssetsManager.getWebAssetPath() + File.separator + md5Name;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static boolean deleteWebAsset(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                return file.delete();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return false;
    }

    public static InputStream getWebAssetStream(String url) throws FileNotFoundException {
        if (!TextUtils.isEmpty((CharSequence)url) && WebAssetsManager.checkWebAssetExist(url)) {
            return new FileInputStream(new File(WebAssetsManager.getWebAssetFilePath(url)));
        }
        return null;
    }

    public static String subStringScheme(String url) {
        try {
            Uri parse = Uri.parse((String)url);
            String path = parse.getPath();
            String host = parse.getHost();
            String urlWithoutScheme = TextUtils.concat((CharSequence[])new CharSequence[]{host, path}).toString();
            return urlWithoutScheme;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return url;
        }
    }

    public static String getWebAssetFilePath(String url) {
        return WebAssetsManager.getWebAssetPath() + WebAssetsManager.getWebAssetName(url);
    }

    public static String getWebAssetName(String url) {
        return MD5Utils.toMd5(WebAssetsManager.subStringScheme(url));
    }

    public static String getWebAssetPath() {
        return CoreUtil.getContext().getFilesDir().getAbsolutePath() + File.separator + SSP_WEB_ASSETS + File.separator;
    }
}

