/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.widget.webview;

import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.widget.net.HttpManager;
import com.cloud.hisavana.sdk.common.widget.webview.AssetCleanTask;
import com.cloud.hisavana.sdk.common.widget.webview.IdleDownloadTask;
import com.cloud.hisavana.sdk.common.widget.webview.WebAssetsManager;
import com.cloud.hisavana.sdk.common.widget.webview.WebUrlData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class WebNativeLoader {
    private WebNativeLoader() {
    }

    public static void preload(final List<WebUrlData> webDataList) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                WebNativeLoader.preloadInner(webDataList);
            }
        });
    }

    private static void preloadInner(List<WebUrlData> webDataList) {
        if (webDataList != null && !webDataList.isEmpty()) {
            AdLogUtil.Log().d("webview--", "TWebViewNativeLoader size = " + webDataList.size());
            WebNativeLoader.preloadAssetIfExist(webDataList);
            WebNativeLoader.cleanAssetIfRemoved(webDataList);
        }
    }

    private static void cleanAssetIfRemoved(List<WebUrlData> webDataList) {
        if (webDataList != null && !webDataList.isEmpty()) {
            Looper.myQueue().addIdleHandler((MessageQueue.IdleHandler)new AssetCleanTask(webDataList));
        }
    }

    private static void preloadAssetIfExist(List<WebUrlData> webDataList) {
        if (webDataList != null && !webDataList.isEmpty()) {
            int needPreloadNum = 0;
            for (WebUrlData webUrlData : webDataList) {
                if (webUrlData == null || WebNativeLoader.checkAssetExist(webUrlData.getUrl())) continue;
                ++needPreloadNum;
                Looper.myQueue().addIdleHandler((MessageQueue.IdleHandler)new IdleDownloadTask(webUrlData));
            }
            AdLogUtil.Log().d("webview--", "TWebViewNativeLoader need preload num = " + needPreloadNum);
        }
    }

    private static boolean checkAssetExist(String url) {
        return !TextUtils.isEmpty((CharSequence)url) && WebAssetsManager.checkWebAssetExist(url);
    }

    public static void post(String urlPath, Map<String, String> headers, JSONObject paramsObj, HttpManager.OnRequestCallback callback) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("Accept-Timezone", "UTC");
        HttpManager.post(urlPath, headers, paramsObj, callback);
    }
}

