/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.widget.webview;

import android.content.Context;
import android.os.Bundle;
import com.cloud.abtest.ABTestVariant;
import com.cloud.galileo.GalileoManager;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.widget.galileoab.GalileoAB;
import com.cloud.hisavana.sdk.common.widget.webview.WebViewManager;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;

public class WebViewDataTracker {
    public static final String PARAM_WEB_URL = "web_url";
    public static final String PARAM_GALILEO_AB = "web_galileo";
    public static final String PARAM_WEB_DURATION = "web_duration";
    public static final String PARAM_VAR_ID = "var_id";

    private WebViewDataTracker() {
    }

    public static void trackWebClick(Context context, AdsDTO adsDTO) {
        Bundle bundle = new Bundle();
        if (adsDTO != null) {
            bundle.putString(PARAM_WEB_URL, adsDTO.getClickUrl());
        }
        bundle.putString(PARAM_GALILEO_AB, WebViewDataTracker.checkGalileoAb());
        bundle.putLong(PARAM_VAR_ID, WebViewDataTracker.getVarID(context).longValue());
        AthenaTracker.trackWebViewClick(adsDTO, bundle);
    }

    public static void trackWebComplete(Context context, AdsDTO adsDTO) {
        Bundle bundle = new Bundle();
        if (adsDTO != null) {
            bundle.putString(PARAM_WEB_URL, adsDTO.getClickUrl());
        }
        bundle.putString(PARAM_GALILEO_AB, WebViewDataTracker.checkGalileoAb());
        bundle.putLong(PARAM_WEB_DURATION, WebViewDataTracker.calculateWebOpenDuration(adsDTO));
        bundle.putLong(PARAM_VAR_ID, WebViewDataTracker.getVarID(context).longValue());
        AthenaTracker.trackWebViewComplete(adsDTO, bundle);
    }

    private static long calculateWebOpenDuration(AdsDTO adsDTO) {
        if (adsDTO.getClickUrlTs() == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - adsDTO.getClickUrlTs();
    }

    public static String checkGalileoAb() {
        return WebViewManager.optimize() ? "B" : "A";
    }

    public static Long getVarID(Context context) {
        try {
            if (context == null) {
                return -1L;
            }
            ABTestVariant variant = GalileoManager.Companion.getVariant(context, (long)GalileoAB.getLayerId());
            if (variant != null) {
                return variant.varId;
            }
        }
        catch (Exception e2) {
            return -1L;
        }
        return -1L;
    }
}

