package com.cloud.hisavana.sdk.api.adx;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import com.cloud.hisavana.sdk.api.listener.OnSkipListener;
import com.cloud.hisavana.sdk.api.listener.TaRequest;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.Preconditions;
import com.cloud.hisavana.sdk.internal.splash.TranSplash;
import com.transsion.core.utils.ScreenUtil;

/**
 * ADX开屏对外提供的接口
 * 仅仅提供容器的能力 不参与数据处理
 */
public class ASplash extends RelativeLayout {

    /**
     * 这个对象里面 解决了 数据哪里来的问题
     */
    private TranSplash mSplash = null;

    private RelativeLayout mSplashLayout = null;


    // =============================================================================================


    public ASplash(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ASplash(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, "");
    }

    public ASplash(Context context, String placementId) {
        super(context, null);
        init(context, placementId);
    }

    /**
     * 初始化 创建了容器
     * 数据处理对象
     */
    private void init(Context context, String placementId) {
        mSplashLayout = new RelativeLayout(this.getContext());
        this.addView(mSplashLayout, ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        mSplash = new TranSplash(context, mSplashLayout, placementId);
    }


    // =============================================================================================

    /**
     * 设置广告位id
     */
    public void setPlacementId(String placementId) {
        mSplash.setPlacementId(placementId);
    }
    /**
     * 设置请求类型
     * @param requestType
     */
    public void setRequestType(int requestType) {
        mSplash.setRequestType(requestType);
    }
    /**
     * 设置是否是打底广告
     *
     * @param isDefaultAd
     */
    public void setDefaultAd(boolean isDefaultAd) {
        mSplash.setDefaultAd(isDefaultAd);
    }

    /**
     * 开屏允许外部 跳过
     */
    public void setAllowSkipOut(boolean mIsOpenDpl) {
        mSplash.setAllowSkipOut(mIsOpenDpl);
    }

    /**
     * 设置跳过的监听器
     */
    public void setSkipListener(OnSkipListener listener) {
        mSplash.setSkipListener(listener);
    }

    /**
     * 设置广告的请求
     */
    public void setAdRequest(@NonNull TaRequest adRequest) {
        mSplash.setAdRequest(adRequest);
    }

    /**
     * 加载广告
     */
    public void loadAd(String requestId) {
        mSplash.loadAd(requestId);
    }

    /**
     * 广告是否有效
     *
     * @return
     */
    public boolean isAdValid() {
        return mSplash.isAdValid();
    }

    public double getBidPrice(){
        return mSplash.getBidPrice();
    }
    public void setSecondPrice(double secondPrice){
        mSplash.setSecondPrice(secondPrice);
    }

    public String getDefaultAdRequestId() {
        return mSplash.getDefaultAdRequestId();
    }
    /**
     * 显示广告 --> 在广告加载完成之后显示
     */
    public void show() {
        Preconditions.checkIsOnMainThread();
        mSplash.show();
    }

    /**
     * 在调用界面销毁的时候调用
     */
    public void destroy() {
        mSplash.destroy();
    }
}

