package com.cloud.hisavana.sdk.common.ps;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.common.widget.TranCircleImageView;
import com.cloud.hisavana.sdk.data.bean.response.AdPsResponseBody;

import java.util.List;

/**
 * Created by wenjing.luo on 2022/03/28.
 * ps中间页pslinklist的adapter
 */

public class PsLinkRecyclerAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private LayoutInflater mLayoutInflater;
    public List<AdPsResponseBody.PsLinkListDTO> data;

    public PsLinkRecyclerAdapter(Context context, List<AdPsResponseBody.PsLinkListDTO> data) {
        this.data = data;
        mLayoutInflater = LayoutInflater.from(context);
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (data != null){
            if (data.size() == 2) {
                return new ViewHolder(mLayoutInflater.inflate(R.layout.item_ad_ps_pslink_less, parent, false));
            } else if (data.size() == 3) {
                View itemView =mLayoutInflater.inflate(R.layout.item_ad_ps_pslink, parent, false);
                ViewGroup.LayoutParams layoutParams = itemView.getLayoutParams();
                if (layoutParams != null){
                    layoutParams.width = ViewGroup.LayoutParams.WRAP_CONTENT;
                }
                return new ViewHolder(itemView);
            }
        }
        return new ViewHolder(mLayoutInflater.inflate(R.layout.item_ad_ps_pslink, parent, false));
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int position) {
        PsRequestManager.renderImageView(data.get(position).getIcon(), ((ViewHolder) holder).icon,null);
        final String appName = data.get(position).getAppName();
        ((ViewHolder) holder).appName.setText(appName);
        ((ViewHolder) holder).star.setText(data.get(position).getStar());
        ((ViewHolder) holder).appSize.setText(String.valueOf(data.get(position).getSize()));
        final String dplink = data.get(position).getDpLink();
        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (onViewItemClickListener != null){
                    onViewItemClickListener.onClick(dplink,appName);
                }
            }
        });
    }

    class ViewHolder extends RecyclerView.ViewHolder {
        public TranCircleImageView icon;
        public TextView appName;
        public TextView star;
        public TextView appSize;

        public ViewHolder(View itemView) {
            super(itemView);
            icon = itemView.findViewById(R.id.icon);
            appName = itemView.findViewById(R.id.tv_appName);
            star = itemView.findViewById(R.id.star);
            appSize = itemView.findViewById(R.id.tv_size);
        }
    }

    @Override
    public int getItemCount() {
        return data.size();
    }

    private OnViewItemClickListener onViewItemClickListener;
    public interface OnViewItemClickListener
    {
        void onClick(String dplink,String psLinkAppName);
    }

    public OnViewItemClickListener getOnViewItemClickListener() {
        return onViewItemClickListener;
    }

    public void setOnViewItemClickListener(OnViewItemClickListener onViewItemClickListener) {
        this.onViewItemClickListener = onViewItemClickListener;
    }
}
