package com.cloud.hisavana.sdk.common.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;

import com.cloud.hisavana.sdk.common.util.AdLogUtil;


/**
 * Created by jianbing.yu on 2019/1/25.
 */

public class ViewGestureDetector extends GestureDetector {
    @NonNull
    private GestureListener mGestureListener;

    public ViewGestureDetector(@NonNull Context context) {
        this(context, new GestureListener());
    }

    private ViewGestureDetector(Context context, @NonNull GestureListener gestureListener) {
        super(context, gestureListener);
        mGestureListener = gestureListener;
        setIsLongpressEnabled(false);
    }

    void onResetUserClick() {
        mGestureListener.onResetUserClick();
    }

    public boolean isClicked() {
        return mGestureListener.isClicked();
    }

    @Deprecated
    void setGestureListener(@NonNull GestureListener gestureListener) {
        mGestureListener = gestureListener;
    }

    public void setClicked(boolean clicked) {
        mGestureListener.mIsClicked = clicked;
    }

    /**
     * Track user interaction in a separate class
     */
    public static class GestureListener extends GestureDetector.SimpleOnGestureListener {
        boolean mIsClicked = false;

        void onResetUserClick() {
            mIsClicked = false;
        }

        boolean isClicked() {
            return mIsClicked;
        }

        @Override
        public boolean onSingleTapUp(MotionEvent e) {
            mIsClicked = true;
            return super.onSingleTapUp(e);
        }
    }
}
