package com.cloud.hisavana.sdk.common.widget.config;

import android.text.TextUtils;

import com.cloud.hisavana.sdk.common.util.AdLogUtil;

import org.json.JSONObject;

/**
 * {"code":0,"message":null,"data":{"webview":[{"url":"https://ipage.test.eagllwin.com/static/vendor.d9a6ab97.js","md5":"d9a6ab97"}]}}
 */
public class ConfigParser {

    public static ConfigData parser(String configStr) {
        if (!TextUtils.isEmpty(configStr)) {
            try {
                ConfigData data = new ConfigData();
                JSONObject jsonObject = new JSONObject(configStr);
                data.setCode(jsonObject.optInt("code"));
                data.setMessage(jsonObject.optString("message"));
                JSONObject dataObject = jsonObject.optJSONObject("data");
                data.setDataObj(dataObject);
                return data;
            } catch (Exception e) {
                e.printStackTrace();
                AdLogUtil.Log().d("webview--","TWebViewManager ConfigParser Exception e =" + e.toString());
            }
        }
        return null;
    }
}
