package com.cloud.hisavana.sdk.common.widget.galileoab;

import android.content.Context;

import com.cloud.abtest.ABTest;
import com.cloud.galileo.GalileoManager;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.widget.webview.WebViewOptimizeConfig;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.tmc.utils.LogUtil;

public class GalileoAB {
    //debug
    private static final String PRE_KEY = "cuAQuKK.r0Lo5HhHilEN8x2eTiaYoGdI";
    private static final int PRE_PROJECT_ID = 10;
    private static final int PRE_WEB_VIEW_LAYER_ID = 84;

    //release
    private static final String RELEASE_KEY = "YfhiESR.BH8boChVpH4kEbKgL9qA9njh";
    private static final int RELEASE_PROJECT_ID = 13;
    private static final int RELEASE_WEB_VIEW_LAYER_ID = 72;

    private GalileoAB() {
    }

    public static void init(Context context) {
        registerGalileo();

        new GalileoManager.Builder(context)
                .setAppId(getProjectId())
                .setABServer(getGalileoUrl())
                .setAppKey(getGalileoKey())
                .setDebugMode(SspAd.isDebug())
                .build();
    }

    private static void registerGalileo() {
        try {
            GalileoManager.Companion.getGet().register(getLayerId(), WebViewOptimizeConfig.class);
        } catch (Exception e) {
            LogUtil.INSTANCE.e(e);
        }
    }

    private static String getGalileoKey() {
        return AdxServerConfig.getAppModle() == AdxServerConfig.RELEASE ? RELEASE_KEY : PRE_KEY;
    }

    public static int getLayerId() {
        return AdxServerConfig.getAppModle() == AdxServerConfig.RELEASE ? RELEASE_WEB_VIEW_LAYER_ID : PRE_WEB_VIEW_LAYER_ID;
    }

    private static int getProjectId() {
        return AdxServerConfig.getAppModle() == AdxServerConfig.RELEASE ? RELEASE_PROJECT_ID : PRE_PROJECT_ID;
    }

    /**
     * ab请求的地址：测试环境/Pre环境/生产环境
     */
    private static int getGalileoUrl() {
        return AdxServerConfig.getAppModle() == AdxServerConfig.RELEASE ? ABTest.SERVER_ONLINE : ABTest.SERVER_PRE;
    }
}
