package com.cloud.hisavana.sdk.common.widget.webview;

import android.text.TextUtils;

import com.cloud.hisavana.sdk.BuildConfig;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.transsion.core.CoreUtil;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class WebViewAssetFormat {

    private static boolean open = false;

    public static void format() {
        if (BuildConfig.DEBUG && open) {
            String json = "{\"data\":[\"http://ipage.test.eagllwin.com/static/AppLandPage1.3885a5d2.js\",\"http://ipage.test.eagllwin.com/static/AppLandPage1.c78510a5.css\",\"http://ipage.test.eagllwin.com/static/AppLandPage1-legacy.517dcbb8.js\",\"http://ipage.test.eagllwin.com/static/AppLandPage2.9d97e5a3.js\",\"http://ipage.test.eagllwin.com/static/AppLandPage2.a8dbb945.css\",\"http://ipage.test.eagllwin.com/static/AppLandPage2-legacy.c632c2b0.js\",\"http://ipage.test.eagllwin.com/static/app-top.ce9581ec.webp\",\"http://ipage.test.eagllwin.com/static/BrandLandPage1.358d0bb0.css\",\"http://ipage.test.eagllwin.com/static/BrandLandPage1.d9719e6a.js\",\"http://ipage.test.eagllwin.com/static/BrandLandPage1-legacy.41039a8b.js\",\"http://ipage.test.eagllwin.com/static/BrandLandPage2.4915f421.css\",\"http://ipage.test.eagllwin.com/static/BrandLandPage2.4e0d33ba.js\",\"http://ipage.test.eagllwin.com/static/BrandLandPage2-legacy.79192a8c.js\",\"http://ipage.test.eagllwin.com/static/CouponDetail.0b1a850f.css\",\"http://ipage.test.eagllwin.com/static/CouponDetail.c87538d2.js\",\"http://ipage.test.eagllwin.com/static/CouponDetail-legacy.0347182c.js\",\"http://ipage.test.eagllwin.com/static/CouponLandPage1.321862a7.js\",\"http://ipage.test.eagllwin.com/static/CouponLandPage1.43651eed.css\",\"http://ipage.test.eagllwin.com/static/CouponLandPage1-legacy.63e4c9ac.js\",\"http://ipage.test.eagllwin.com/static/CouponLandPage2.9079803f.js\",\"http://ipage.test.eagllwin.com/static/CouponLandPage2.be9c2905.css\",\"http://ipage.test.eagllwin.com/static/CouponLandPage2-legacy.bef5256d.js\",\"http://ipage.test.eagllwin.com/static/index.3177c6d8.js\",\"http://ipage.test.eagllwin.com/static/index.75ce968e.css\",\"http://ipage.test.eagllwin.com/static/index.c998d1e7.js\",\"http://ipage.test.eagllwin.com/static/index-legacy.b14be664.js\",\"http://ipage.test.eagllwin.com/static/index-legacy.b79bbac5.js\",\"http://ipage.test.eagllwin.com/static/LandPage.90d1eb70.css\",\"http://ipage.test.eagllwin.com/static/LandPage.b3211b89.js\",\"http://ipage.test.eagllwin.com/static/LandPage-legacy.97dca8ce.js\",\"http://ipage.test.eagllwin.com/static/Pay.5bd6dce9.js\",\"http://ipage.test.eagllwin.com/static/Pay.d35151a7.css\",\"http://ipage.test.eagllwin.com/static/pay-error.7236b80c.webp\",\"http://ipage.test.eagllwin.com/static/Pay-legacy.84865ed0.js\",\"http://ipage.test.eagllwin.com/static/pay-loading.bd03eb2f.webp\",\"http://ipage.test.eagllwin.com/static/polyfills-legacy.b8cb7d79.js\",\"http://ipage.test.eagllwin.com/static/SingleCouponLandPage1.36499c3b.js\",\"http://ipage.test.eagllwin.com/static/SingleCouponLandPage1.fed3ecbe.css\",\"http://ipage.test.eagllwin.com/static/SingleCouponLandPage1-legacy.02fa6efe.js\",\"http://ipage.test.eagllwin.com/static/SingleCouponLandPage2.b0b760d6.css\",\"http://ipage.test.eagllwin.com/static/SingleCouponLandPage2.fab09df8.js\",\"http://ipage.test.eagllwin.com/static/SingleCouponLandPage2-legacy.f4ad2606.js\",\"http://ipage.test.eagllwin.com/static/site_back.98562c43.js\",\"http://ipage.test.eagllwin.com/static/site_back-legacy.13f7e70c.js\",\"http://ipage.test.eagllwin.com/static/site_coupon_detail_pay_success.1d150afe.webp\",\"http://ipage.test.eagllwin.com/static/site_detail_black.b6b70ce0.js\",\"http://ipage.test.eagllwin.com/static/site_detail_black-legacy.ebe634e3.js\",\"http://ipage.test.eagllwin.com/static/site_detail_gray.0c62b5e5.js\",\"http://ipage.test.eagllwin.com/static/site_detail_gray-legacy.aca26f0a.js\",\"http://ipage.test.eagllwin.com/static/useCouponRepositories.59129921.js\",\"http://ipage.test.eagllwin.com/static/useCouponRepositories-legacy.432f24fd.js\",\"http://ipage.test.eagllwin.com/static/utils.ea681ed5.js\",\"http://ipage.test.eagllwin.com/static/utils-legacy.e961aa07.js\",\"http://ipage.test.eagllwin.com/static/vendor.084dc1ba.css\",\"http://ipage.test.eagllwin.com/static/vendor.6c6c771b.js\",\"http://ipage.test.eagllwin.com/static/vendor-legacy.c20325a5.js\"]}";
            String format = format(json);
            if (!TextUtils.isEmpty(format)) {
                format = format.replaceAll("\\\\", "");
                write(format);
            }

            AdLogUtil.Log().d("webview--","WebViewAssetFormat format = " + format);
        }
    }

    public static void write(String json) {
        FileWriter writer;
        try {
            File file = new File(CoreUtil.getContext().getFilesDir() + "/web_asset_json");
            writer = new FileWriter(file);
            writer.write(json);
            writer.flush();
            writer.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String format(String json) {
        try {
            JSONObject jsonObject = new JSONObject(json);
            JSONArray jsonArray = jsonObject.optJSONArray("data");

            JSONArray newArray = new JSONArray();
            if (jsonArray != null && jsonArray.length() > 0) {
                for (int i = 0; i < jsonArray.length(); i++) {
                    JSONObject newObj = new JSONObject();
                    String url = jsonArray.optString(i);
                    newObj.put("url", url);
                    newArray.put(newObj);
                }
            }
            return newArray.toString();
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

}
