package com.cloud.hisavana.sdk.common.widget.webview;

import com.cloud.hisavana.sdk.common.widget.config.ConfigData;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class WebViewConfigParser {

    public static List<WebUrlData> parse(JSONArray jsonArray) {
        if (jsonArray == null || jsonArray.length() <= 0) {
            return null;
        }
        try {
            List<WebUrlData> webUrlDataList = new ArrayList<>();
            for (int i = 0; i < jsonArray.length(); i++) {
                WebUrlData webUrlData = new WebUrlData();
                JSONObject webUrlObj = null;
                webUrlObj = jsonArray.getJSONObject(i);
                webUrlData.setMd5(webUrlObj.optString("md5"));
                webUrlData.setUrl(webUrlObj.optString("url"));
                webUrlDataList.add(webUrlData);
            }
            return webUrlDataList;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
