package com.cloud.hisavana.sdk.common.widget.webview;

import android.content.Context;
import android.os.Bundle;

import com.cloud.abtest.ABTestVariant;
import com.cloud.galileo.GalileoManager;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.widget.galileoab.GalileoAB;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;

public class WebViewDataTracker {

    public static final String PARAM_WEB_URL = "web_url";
    public static final String PARAM_GALILEO_AB = "web_galileo";
    public static final String PARAM_WEB_DURATION = "web_duration";
    public static final String PARAM_VAR_ID = "var_id";

    private WebViewDataTracker() {
    }

    public static void trackWebClick(Context context, AdsDTO adsDTO) {
        Bundle bundle = new Bundle();
        if (adsDTO != null) {
            bundle.putString(WebViewDataTracker.PARAM_WEB_URL, adsDTO.getClickUrl());
        }
        bundle.putString(WebViewDataTracker.PARAM_GALILEO_AB, WebViewDataTracker.checkGalileoAb());
        bundle.putLong(WebViewDataTracker.PARAM_VAR_ID, getVarID(context));
        AthenaTracker.trackWebViewClick(adsDTO, bundle);
    }
    public static void trackWebComplete(Context context, AdsDTO adsDTO) {
        Bundle bundle = new Bundle();
        if (adsDTO != null) {
            bundle.putString(WebViewDataTracker.PARAM_WEB_URL, adsDTO.getClickUrl());
        }
        bundle.putString(WebViewDataTracker.PARAM_GALILEO_AB, WebViewDataTracker.checkGalileoAb());
        bundle.putLong(WebViewDataTracker.PARAM_WEB_DURATION, calculateWebOpenDuration(adsDTO));
        bundle.putLong(WebViewDataTracker.PARAM_VAR_ID, getVarID(context));
        AthenaTracker.trackWebViewComplete(adsDTO, bundle);
    }

    private static long calculateWebOpenDuration(AdsDTO adsDTO) {
        if (adsDTO.getClickUrlTs() == 0) {
            return 0;
        }
        return System.currentTimeMillis() - adsDTO.getClickUrlTs();
    }

    public static String checkGalileoAb() {
        return WebViewManager.optimize() ? "B" : "A";
    }

    public static Long getVarID(Context context) {
        try {
            if (context == null) return -1L;
            ABTestVariant variant = GalileoManager.Companion.getVariant(context, GalileoAB.getLayerId());
            if (variant != null) {
                return variant.varId;
            }
        } catch (Exception e) {
            return -1L;
        }
        return -1L;
    }
}
