/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.widget.config;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.widget.config.AbstractConfig;
import com.cloud.hisavana.sdk.common.widget.config.ConfigCacheManager;
import com.cloud.hisavana.sdk.common.widget.config.ConfigData;
import com.cloud.hisavana.sdk.common.widget.config.ConfigParser;
import com.cloud.hisavana.sdk.common.widget.net.HttpManager;
import com.transsion.core.CoreUtil;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class ConfigManager {
    private static volatile ConfigManager mInstance;
    private static Map<String, Class<? extends AbstractConfig>> mClassMap;
    private static final String HOST_RELEASE = "https://cloud-config-api.shalltry.com";
    private static final String HOST_DEBUG = "https://cloud-config-api-test.shalltry.com";

    private ConfigManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ConfigManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void register(String feature, Class<? extends AbstractConfig> clazz) {
        if (mClassMap != null && !mClassMap.containsKey(feature)) {
            mClassMap.put(feature, clazz);
        }
    }

    public void init(Context context, String key, OnConfigCallback callback) {
        try {
            String url = this.getHost() + "/common/cloudconfig/v1/consumer-not-login/configkeyvalue/query/get";
            JSONObject paramsObj = new JSONObject();
            paramsObj.put("key", (Object)key);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept-Timezone", "UTC");
            HttpManager.post(url, headers, paramsObj, new RequestCallbackImpl(callback));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private String getHost() {
        return HOST_RELEASE;
    }

    private void notifyObserver(ConfigData configData) {
        if (mClassMap != null && mClassMap.size() > 0 && configData != null) {
            this.dispatchToEachObserver(mClassMap, configData.getDataObj());
        }
    }

    private void dispatchToEachObserver(Map<String, Class<? extends AbstractConfig>> observerMap, JSONObject dataObj) {
        if (observerMap == null || observerMap.isEmpty() || dataObj == null) {
            return;
        }
        for (String feature : mClassMap.keySet()) {
            Class<? extends AbstractConfig> aClass;
            boolean has;
            if (TextUtils.isEmpty((CharSequence)feature) || !(has = dataObj.has(feature))) continue;
            if (!(dataObj.opt(feature) instanceof JSONArray)) {
                throw new IllegalArgumentException("feature value must be JSONArray");
            }
            JSONArray jsonArray = dataObj.optJSONArray(feature);
            if (jsonArray == null || jsonArray.length() == 0 || (aClass = mClassMap.get(feature)) == null) continue;
            try {
                AbstractConfig config = aClass.newInstance();
                config.onLoaded(jsonArray);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                AdLogUtil.Log().d("webview--", "ConfigManager dispatchToEachObserver error = " + e2.toString());
            }
        }
    }

    public static JSONArray getByFeature(String feature) {
        String config = ConfigCacheManager.get(CoreUtil.getContext());
        if (TextUtils.isEmpty((CharSequence)config)) {
            return null;
        }
        ConfigData configData = ConfigParser.parser(config);
        if (configData == null) {
            return null;
        }
        JSONObject dataObj = configData.getDataObj();
        if (dataObj == null || !dataObj.has(feature)) {
            return null;
        }
        return dataObj.optJSONArray(feature);
    }

    static {
        mClassMap = new HashMap<String, Class<? extends AbstractConfig>>();
    }

    class RequestCallbackImpl
    implements HttpManager.OnRequestCallback {
        private final OnConfigCallback callback;

        public RequestCallbackImpl(OnConfigCallback callback) {
            this.callback = callback;
        }

        @Override
        public void onSuccess(String response) {
            AdLogUtil.Log().d("webview--", "ConfigManager init =" + response);
            ConfigCacheManager.set(CoreUtil.getContext(), response);
            final ConfigData configData = ConfigParser.parser(response);
            ConfigManager.this.notifyObserver(configData);
            if (this.callback != null && configData != null) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        RequestCallbackImpl.this.callback.onCallback(configData);
                    }
                });
            }
        }

        @Override
        public void onFail(int code, String message) {
            AdLogUtil.Log().d("webview--", "ConfigManager init fail code =" + code + " error = " + message);
            if (this.callback != null) {
                this.callback.onFail(code, message);
            }
        }
    }

    public static interface OnConfigCallback {
        public void onCallback(ConfigData var1);

        public void onFail(int var1, String var2);

        public static abstract class ConfigCallbackImpl
        implements OnConfigCallback {
            @Override
            public void onFail(int code, String error) {
                AdLogUtil.Log().d("webview--", "ConfigManager onFail code = " + code + " error = " + error);
            }
        }
    }
}

