/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.widget.webview;

import android.app.Activity;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import androidx.annotation.Nullable;
import com.cloud.hisavana.sdk.common.activity.TAdExposureActivity;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.widget.net.HttpManager;
import com.cloud.hisavana.sdk.common.widget.webview.WebNativeLoader;
import com.cloud.hisavana.sdk.common.widget.webview.WebViewManager;
import com.tmc.webview.CoreJsBridge;
import java.lang.ref.WeakReference;
import org.json.JSONObject;

public class WebViewInterface
extends CoreJsBridge {
    private final WebView mWebView;
    private final Handler mMainHandler;
    private final WeakReference<Activity> mWebViewActivity;

    public WebViewInterface(Activity webViewActivity, WebView webview) {
        this.mWebViewActivity = new WeakReference<Activity>(webViewActivity);
        this.mWebView = webview;
        this.mMainHandler = new Handler(Looper.getMainLooper());
    }

    @JavascriptInterface
    public String checkNativeLoad() {
        AdLogUtil.Log().d("webview--", "WebViewInterface checkNativeLoad");
        return WebViewManager.optimize() ? "1" : "";
    }

    @JavascriptInterface
    public void onLoadByNative(String jsonStr, final String callbackName) {
        AdLogUtil.Log().d("webview--", "WebViewInterface onLoadByNative, jsonStr = " + jsonStr + " callbackName = " + callbackName);
        if (TextUtils.isEmpty((CharSequence)callbackName)) {
            return;
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(jsonStr);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        String requestUrl = null;
        JSONObject paramJo = null;
        if (jsonObject != null) {
            requestUrl = jsonObject.optString("requestUrl");
            paramJo = jsonObject.optJSONObject("requestParam");
        }
        if (TextUtils.isEmpty(requestUrl)) {
            this.executeJavascript(callbackName, "");
            return;
        }
        requestUrl = this.checkToRepairUrlIfNeeded(requestUrl);
        AdLogUtil.Log().d("webview--", "WebViewInterface onLoadByNative, jsonStr = " + jsonStr + " callbackName = " + callbackName + " final url = " + requestUrl);
        WebNativeLoader.post(requestUrl, null, paramJo, new HttpManager.OnRequestCallback(){

            @Override
            public void onSuccess(String response) {
                AdLogUtil.Log().d("webview--", "WebViewInterface onSuccess = " + response);
                WebViewInterface.this.executeJavascript(callbackName, response);
            }

            @Override
            public void onFail(int code, String message) {
                AdLogUtil.Log().d("webview--", "WebViewInterface onFail, code = " + code + " error = " + message);
                WebViewInterface.this.executeJavascript(callbackName, "");
            }
        });
    }

    private void executeJavascript(final String callbackName, final String response) {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (WebViewInterface.this.mWebView == null) {
                    return;
                }
                String js = "javascript:" + callbackName + "(" + response + ")";
                if (Build.VERSION.SDK_INT >= 19) {
                    WebViewInterface.this.mWebView.evaluateJavascript(js, (ValueCallback)new ValueCallback<String>(){

                        public void onReceiveValue(String value) {
                            AdLogUtil.Log().d("webview--", "WebViewInterface executeJavascript, onReceiveValue = " + value);
                        }
                    });
                } else {
                    WebViewInterface.this.mWebView.loadUrl(js);
                }
            }
        });
    }

    private String checkToRepairUrlIfNeeded(String requestUrl) {
        if (TextUtils.isEmpty((CharSequence)requestUrl)) {
            return requestUrl;
        }
        if (!requestUrl.startsWith("https") && !requestUrl.startsWith("http")) {
            requestUrl = TextUtils.concat((CharSequence[])new CharSequence[]{"https://", requestUrl}).toString();
        }
        return requestUrl;
    }

    @JavascriptInterface
    public void onWebComplete() {
        AdLogUtil.Log().d("webview--", "WebViewInterface onWebComplete");
        if (this.mWebViewActivity != null && this.mWebViewActivity.get() != null && this.mWebViewActivity.get() instanceof TAdExposureActivity) {
            this.mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    TAdExposureActivity activity = (TAdExposureActivity)((Object)WebViewInterface.this.mWebViewActivity.get());
                    activity.a();
                }
            });
        }
    }

    @Nullable
    public String getSystemInfo() {
        return null;
    }

    public void goBack() {
        if (null != this.mWebView && this.mWebView.canGoBack()) {
            this.mWebView.goBack();
        } else if (null != this.mWebViewActivity.get()) {
            ((Activity)this.mWebViewActivity.get()).finish();
        }
    }
}

