/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.widget.webview;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.widget.config.Config;
import com.cloud.hisavana.sdk.common.widget.config.ConfigData;
import com.cloud.hisavana.sdk.common.widget.webview.MimeTypeMapUtils;
import com.cloud.hisavana.sdk.common.widget.webview.WebAssetsManager;
import com.cloud.hisavana.sdk.common.widget.webview.WebNativeLoader;
import com.cloud.hisavana.sdk.common.widget.webview.WebUrlData;
import com.cloud.hisavana.sdk.common.widget.webview.WebViewConfigParser;
import com.cloud.hisavana.sdk.common.widget.webview.WebViewInterface;
import java.io.InputStream;
import java.util.List;

public class WebViewManager {
    private static boolean mOptimize = false;
    private static Context mContext;

    private WebViewManager() {
    }

    public static void init(Context context) {
        mContext = context.getApplicationContext();
        if (WebViewManager.optimize()) {
            WebViewManager.initWebView();
            WebViewManager.initConfigAndPreloadAsset(context);
        }
    }

    private static void initWebView() {
        WebViewManager.prepare();
    }

    private static void initConfigAndPreloadAsset(Context context) {
        Config.init(context, new Config.OnConfigCallback(){

            @Override
            public void onCallback(ConfigData configData) {
                if (configData != null && configData.getDataObj() != null) {
                    try {
                        List<WebUrlData> webUrlDataList = WebViewConfigParser.parse(configData.getDataObj().getJSONArray("webview"));
                        WebNativeLoader.preload(webUrlDataList);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
        });
    }

    private static void prepare() {
        if (WebViewManager.optimize()) {
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

                        public boolean queueIdle() {
                            long start = System.currentTimeMillis();
                            final WebView webView = WebViewManager.createWebView(mContext);
                            if (webView != null) {
                                handler.postDelayed(new Runnable(){

                                    @Override
                                    public void run() {
                                        WebViewManager.destroy(webView);
                                    }
                                }, 2000L);
                            }
                            AdLogUtil.Log().d("webview--", "prepare webview, duration = " + (System.currentTimeMillis() - start));
                            return false;
                        }
                    });
                }
            });
        }
    }

    public static boolean checkAssetsExist(String url) {
        if (WebViewManager.optimize()) {
            url = WebViewManager.forDebug(url);
            return WebAssetsManager.checkWebAssetExist(url);
        }
        return false;
    }

    private static String forDebug(String url) {
        return url;
    }

    public static WebResourceResponse onInterceptRequest(String assetsUrl) {
        if (WebViewManager.optimize() && !TextUtils.isEmpty((CharSequence)assetsUrl)) {
            try {
                assetsUrl = WebViewManager.forDebug(assetsUrl);
                InputStream webAssetStream = WebAssetsManager.getWebAssetStream(assetsUrl);
                if (webAssetStream != null) {
                    WebResourceResponse resourceResponse = new WebResourceResponse(MimeTypeMapUtils.checkMimeType(assetsUrl), "UTF-8", webAssetStream);
                    return resourceResponse;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return null;
    }

    public static void addJavaScriptInterface(Activity webViewActivity, WebView webview) {
        AdLogUtil.Log().d("webview--", "addJavaScriptInterface");
        WebViewInterface webViewInterfaceSsp = new WebViewInterface(webViewActivity, webview);
        WebViewInterface webViewInterfaceLofin = new WebViewInterface(webViewActivity, webview);
        WebViewManager.addJavaScriptInterface(webview, (Object)webViewInterfaceSsp, "sspWebview");
    }

    @SuppressLint(value={"JavascriptInterface"})
    public static void addJavaScriptInterface(WebView webview, Object object, String name) {
        webview.getSettings().setJavaScriptEnabled(true);
        webview.addJavascriptInterface(object, name);
    }

    private static WebView createWebView(Context context) {
        return new WebView(context);
    }

    public static void destroy(WebView webView) {
        if (WebViewManager.optimize() && webView != null) {
            ViewParent parent = webView.getParent();
            if (parent != null) {
                ((ViewGroup)parent).removeView((View)webView);
            }
            webView.stopLoading();
            webView.getSettings().setJavaScriptEnabled(false);
            webView.clearHistory();
            webView.removeAllViews();
            webView.destroy();
            webView = null;
            AdLogUtil.Log().d("webview--", "destroy webview");
        }
    }

    public static boolean optimize() {
        return mOptimize;
    }

    public static void updateOptimize(boolean optimize) {
        mOptimize = optimize;
    }
}

