/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.common.widget.CountDownTimer;

public class CountTimeView
extends View
implements View.OnClickListener {
    private Paint mPain;
    private Paint mTextPain;
    private long mStartTime = 6L;
    private CountDownTimer mCountTimer;
    private final int mTextSize;
    private String mTextString = "5s";
    private CountDownTimerListener countDownTimerListener;
    private Bitmap bitmap;
    private static final long AE = 400L;
    private final Rect rect = new Rect();

    public CountTimeView(Context context) {
        this(context, null);
    }

    public CountTimeView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CountTimeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOnClickListener(this);
        this.mTextSize = context.getResources().getDimensionPixelSize(R.dimen.ad_skip_text_size);
        this.initPaint();
    }

    private void initPaint() {
        this.mPain = new Paint();
        this.mPain.setAntiAlias(true);
        this.mPain.setDither(true);
        this.mPain.setStyle(Paint.Style.FILL);
        this.mTextPain = new Paint();
        this.mTextPain.setAntiAlias(true);
        this.mTextPain.setColor(-1);
        this.mTextPain.setTextSize((float)this.mTextSize);
        this.mTextPain.setStrokeWidth(8.0f);
        this.mTextPain.setTextAlign(Paint.Align.CENTER);
    }

    public void setStartTime(int time) {
        this.mStartTime = (long)(time * 1000) + 400L;
        this.createCountTimer();
    }

    public void setCountDownTimerListener(CountDownTimerListener listener) {
        this.countDownTimerListener = listener;
    }

    private void createCountTimer() {
        this.mCountTimer = new CountDownTimer(this.mStartTime, 1000L){

            @Override
            public void onTick(long millisUntilFinished) {
                CountTimeView.this.mTextString = "SKIP " + millisUntilFinished / 1000L;
                CountTimeView.this.invalidate();
            }

            @Override
            public void onFinish() {
                if (CountTimeView.this.countDownTimerListener != null) {
                    CountTimeView.this.countDownTimerListener.onFinish();
                }
            }
        };
    }

    public void start() {
        this.mCountTimer.start();
        if (this.countDownTimerListener != null) {
            this.countDownTimerListener.onStart();
        }
    }

    public void cancel() {
        if (this.mCountTimer != null) {
            this.mCountTimer.cancel();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!TextUtils.isEmpty((CharSequence)this.mTextString)) {
            if (this.bitmap == null) {
                this.bitmap = this.getBg();
            }
            Rect scr = new Rect(0, 0, this.bitmap.getWidth(), this.bitmap.getHeight());
            canvas.drawBitmap(this.bitmap, scr, scr, this.mPain);
            Paint.FontMetrics fontMetrics = this.mTextPain.getFontMetrics();
            int baseLine = (int)((float)(this.rect.bottom + this.rect.top) - fontMetrics.bottom - fontMetrics.top) / 2;
            canvas.drawText(this.mTextString, (float)this.rect.centerX(), (float)baseLine, this.mTextPain);
        }
    }

    private Bitmap getBg() {
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.ad_skip_button);
        if (drawable2 instanceof BitmapDrawable) {
            this.bitmap = ((BitmapDrawable)drawable2).getBitmap();
        } else {
            this.bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(this.bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
        }
        return this.bitmap;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int w, int h2, int oldw, int oldh) {
        this.rect.set(0, 0, this.getWidth(), this.getHeight());
        super.onSizeChanged(w, h2, oldw, oldh);
    }

    public void onClick(View v) {
        if (this.countDownTimerListener != null) {
            this.countDownTimerListener.onClick();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mCountTimer.start();
        if (this.countDownTimerListener != null) {
            this.countDownTimerListener.onStart();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mCountTimer != null) {
            this.mCountTimer.cancel();
        }
    }

    public static interface CountDownTimerListener {
        public void onStart();

        public void onFinish();

        public void onClick();
    }
}

