package com.cloud.hisavana.sdk.api.config;
/* Top Secret */


import static com.cloud.sdk.commonutil.util.CommonLogUtil.MEASURE_TAG;
import static com.cloud.sdk.commonutil.util.CommonLogUtil.NET_LOG;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;

import com.cloud.hisavana.sdk.common.tranmeasure.SspActivityLifecycleCallbacks;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.cloud.sdk.commonutil.athena.PostConstant;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.LifecycleUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.cloud.tmc.vuid.VUID;
import com.tmc.utils.LogUtil;
import com.transsion.core.CoreUtil;
import com.transsion.ga.AthenaAnalytics;

/**
 * 广告管理器
 *
 * @author peng.sun
 * @date 2016/6/30.
 * ==================================
 * Copyright (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public final class AdManager {

    private static AdConfig adConfig;
    public static String AppId;

    /**
     * 是否是测试广告
     */
    public static boolean isTestRequest() {
        if (adConfig != null) {
            return adConfig.testRequest;
        }
        return false;
    }

    public static boolean isDebug() {
        if (adConfig != null) {
            return adConfig.isDebug;
        }
        return false;
    }

    public static void init(Context context, @NonNull final AdConfig config) {
        CoreUtil.init(context);
        init(config);
    }

    /**
     * 初始化
     *
     * @param config
     */
    public static void init(@NonNull final AdConfig config) {
        Preconditions.checkIsOnMainThread();
        if (adConfig != null || config == null) {
            return;
        }
        //打印网络请求的日志
        if (!config.isDebug) {
            NET_LOG.getBuilder().setLogSwitch(Log.isLoggable("AD_NET_LOG", Log.DEBUG));
        }
        if (!config.isDebug) {
            config.isDebug = Log.isLoggable("TA_SDK", Log.DEBUG) || Log.isLoggable("ADSDK", Log.DEBUG);
        }
        adConfig = config;
        //提前加载gaid
        DeviceUtil.getGAId();
        /**
         *
         * Athena初始化方法，建议在宿主应用的application.onCreate方法中调用，否则可能影响Athena功能
         * @param context 上下文
         * @param channel 渠道号 用户统计的维度(比如OS，GP等)，不确定可以填写应用名称
         * @param appId   appId tid/eid的前4位整数区分不同app，只能传四位整数
         * @param isDebug 开启日志
         * @param isHost  开启Crash/日活上报。如果是Application调用初始化函数，需要设置isHost为true。如果是library(比如广告、支付、推送等功能性SDK），需要设置isHost为false。对于isHost为true的模块，Athena SDK会自动采集并上报Crash信息（appid+7998/7999），日活信息(appid+9999)。
         */
        AthenaAnalytics.init(CoreUtil.getContext(), "SSP", PostConstant.TID, adConfig.isDebug, false);
        AthenaAnalytics.setTest(adConfig.testRequest);
        //聚合的日志开关
        AdLogUtil.Log().setLogSwitch(adConfig.isDebug);
//        AdxServerConfig.setAppModle(adConfig.isDebug ? AdxServerConfig.TEST : AdxServerConfig.APP_RELEASE);

        try {
            // 统一注册 ，使用的时候只需调用 addListener 即可。
            LifecycleUtil.registerActivityLifecycleCallbacks((Application) CoreUtil.getContext().getApplicationContext());

            // 曝光测量 注册
            SspActivityLifecycleCallbacks.measureLifecycleCallbacks();
        } catch (Exception e) {
            AdLogUtil.Log().d(MEASURE_TAG, Log.getStackTraceString(e));
        }

        try {
            if (config.vidAppId != null && !config.vidAppId.isEmpty()) {
                if (CoreUtil.getContext().getApplicationContext() instanceof Application) {
                    Application application = (Application) CoreUtil.getContext().getApplicationContext();

                    new VUID.Builder(application)
                            .setTest(AdxServerConfig.getAppModle() != AdxServerConfig.RELEASE)
                            .setAppId(config.vidAppId)
                            .setPackageName(config.vidPackageName)
                            .build();
                    VUID.Companion.setUID(DeviceUtil.getGAId(), true);
                }
            }
        } catch (Exception e) {
            LogUtil.INSTANCE.e(e);
        }
    }

    /**
     * Config 类
     */
    public final static class AdConfig {

        private boolean isDebug;
        //是否是测试广告
        private boolean testRequest = false;
        //vuid对应的appid
        private String vidAppId = "";
        //vuid对应的包名
        private String vidPackageName = "";

        public AdConfig(AdConfigBuilder builder) {
            this.isDebug = builder.isDebug;
            this.testRequest = builder.testRequest;
            this.vidAppId = builder.vidAppId;
            this.vidPackageName = builder.vidPackageName;
        }
    }

    /**
     * ConfigBuilder 类
     */
    public static final class AdConfigBuilder {
        private boolean isDebug = false;
        //是否是测试广告
        private boolean testRequest;

        //vuid对应的appid
        private String vidAppId = "";
        //vuid对应的包名
        private String vidPackageName = "";

        //打开日志
        public AdConfigBuilder setDebug(boolean debug) {
            isDebug = debug;
            CoreUtil.setDebug(isDebug);
            //聚合的日志开关
            AdLogUtil.Log().setLogSwitch(isDebug);
            //打印网络请求的日志
            NET_LOG.getBuilder().setLogSwitch(isDebug);
            return this;
        }

        public AdConfigBuilder testRequest(boolean test) {
            this.testRequest = test;
            return this;
        }

        public AdConfigBuilder setVidAppId(String vidAppId) {
            this.vidAppId = vidAppId;
            return this;
        }

        public AdConfigBuilder setVidPackageName(String vidPackageName) {
            this.vidPackageName = vidPackageName;
            return this;
        }

        public AdConfig build() {
            return new AdConfig(this);
        }
    }


    // =============================================================================================


    /**
     * 优化版本切换开关 1.3.0 曝光监测优化
     * isOptimizedMeasureServices 服务端控制
     * isOptimizedMeasureClient   客户端控制
     */
    private static boolean isServicesOpenOptimizedMeasure = true;
    private static boolean isClientOpenOptimizedMeasure = false;

    public static boolean isServicesOpenOptimizedMeasure() {
        return isServicesOpenOptimizedMeasure;
    }

    public static void setServicesOpenOptimizedMeasure(boolean isOptimized) {
        AdManager.isServicesOpenOptimizedMeasure = isOptimized;
        AdLogUtil.Log().d(MEASURE_TAG, "服务端 " + (isOptimized ? " 开启 " : " 关闭 ") + " 新版本心跳检测");
    }

    public static boolean isClientOpenOptimizedMeasure() {
        return isClientOpenOptimizedMeasure;
    }

    public static void setClientOpenOptimizedMeasure(boolean isOptimized) {
        AdManager.isClientOpenOptimizedMeasure = isOptimized;
        AdLogUtil.Log().d(MEASURE_TAG, "客户端 " + (isOptimized ? " 开启 " : " 关闭 ") + " 新版本心跳检测");
    }

    /**
     * Ssp SDK 使用判断
     *
     * @return true 开启新版本心跳检测、false 关闭新版本心跳检测
     */
    public static boolean isOptimizedMeasure() {
        return isServicesOpenOptimizedMeasure && isClientOpenOptimizedMeasure;
    }


}
