package com.cloud.hisavana.sdk.common.http.listener;

import android.os.Handler;
import android.os.Looper;

import com.cloud.hisavana.sdk.common.constant.TaErrorCode;


/**
 * Created by peng.sun on 2017/6/20.
 */

public abstract class ResponseBaseListener {

    protected Handler handler = null;
    private final static int SUCCESS = 200;

    public ResponseBaseListener() {
        this(Looper.myLooper());
    }

    protected ResponseBaseListener(boolean usePool) {
        this(usePool ? null : Looper.myLooper());
    }

    private ResponseBaseListener(Looper looper) {
        if (looper != null) {
            this.handler = new ResponderHandler(looper);
        } else {
            this.handler = null;
        }
    }

    private class ResponderHandler extends Handler {
        ResponderHandler(Looper looper) {
            super(looper);
        }
    }

    public void onServerRequestFailure(int statusCode, String responseBody, Throwable throwable) {
        onServerRequestFailure(new TaErrorCode(statusCode, "erro msg = " + responseBody));
    }

    public void onServerRequestFailure(int statusCode, byte[] responseBody, Throwable throwable) {
        onServerRequestFailure(new TaErrorCode(statusCode, "erro msg = " + responseBody));
    }

    public void onServerRequestFailure(final TaErrorCode adError) {
        if (this.handler != null) {
            this.handler.post(new Runnable() {
                @Override
                public void run() {
                    onRequestError(adError);
                }
            });
        } else {
            onRequestError(adError);
        }
    }


    public void onServerRequestStart(final int type) {
        if (this.handler != null) {
            this.handler.post(new Runnable() {
                @Override
                public void run() {
                    onRequestStart(type);
                }
            });
        } else {
            onRequestStart(type);
        }
    }

    /**
     * 失败回调
     */
    protected abstract void onRequestError(TaErrorCode adError);

    /**
     * 开始加载的回调
     */
    public void onRequestStart(int type) {}
}
