package com.cloud.hisavana.sdk.common.tracking;


import static com.cloud.sdk.commonutil.util.CommonLogUtil.MEASURE_TAG;

import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;


/**
 * 广告曝光 统一处理
 */
public class ADExposureManager {

    /**
     * 有效曝光 --> 上报服务器
     */
    public static void exposureValid(AdsDTO info) {
        if (null == info) {
            AdLogUtil.Log().d(MEASURE_TAG,"exposureInvalid --> null == info");
            return;
        }
        info.setIsEffectiveShow(1);
        if (info.getIsDefaultAd() == 1) {
            //打底广告曝光新增  is_default_ad_first_show    是否初次曝光（仅在打底广告时记录）   1=是 0=否 int
            String key = info.getCodeSeatId() + "_" + info.getId() + "_" + info.getFill_ts() + "_" + info.getDefaultAdShowCount();
            int isDefaultAdFirstShow = AdxPreferencesHelper.getInstance().getInt(key, -1);
            if (isDefaultAdFirstShow == -1) {
                info.setIsDefaultAdFirstShow(1);
                AdxPreferencesHelper.getInstance().putInt(key, 1);
            } else {
                info.setIsDefaultAdFirstShow(0);
            }
        }
        AdLogUtil.Log().d(MEASURE_TAG,"valid exposure --> to server info = " + info);
        AthenaTracker.trackShow(info);
    }

    /**
     * 无效曝光 --> 上报服务器
     */
    public static void exposureInvalid(AdsDTO info) {
        if (null == info) {
            AdLogUtil.Log().d(MEASURE_TAG,"exposureInvalid --> null == info");
            return;
        }
        info.setIsEffectiveShow(0);
        AdLogUtil.Log().d(MEASURE_TAG,"invalid exposure --> to server info = " + info);
        AthenaTracker.trackShow(info);
    }

}
