package com.cloud.hisavana.sdk.internal.banner;

import static com.cloud.hisavana.sdk.common.constant.Constants.BANNER_SCALE.BANNER_SCALE_203;
import static com.cloud.hisavana.sdk.common.constant.Constants.BANNER_SCALE.BANNER_SCALE_32;
import static com.cloud.hisavana.sdk.common.constant.TaErrorCode.ADM_SCALE_NOT_FIT;
import static com.cloud.hisavana.sdk.common.constant.TaErrorCode.PARSE_BITMAP_ERROR;
import static com.cloud.hisavana.sdk.common.constant.TaErrorCode.RESPONSE_AD_IS_EMPTY;

import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.DownLoadRequest;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.tracking.TrackingManager;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.widget.TadmWebView;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.NetUtil;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;


/**
 * 传音banner类广告
 *
 * @author 孙志刚.
 * @date 2016/12/12.
 * ==================================
 * Copyright (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class BannerGemini {


    private final TranBanner mBannerView;
    private AdsDTO mAdBean = null;
    private WebView webView;//adm媒体载体


    // =============================================================================================


    public BannerGemini(TranBanner bannerView) {
        this.mBannerView = bannerView;
    }

    public void destroy(){
        if (webView != null) {
            webView.clearHistory();
            webView.clearCache(true);
            webView.loadUrl("about:blank"); // clearView() should be changed to loadUrl("about:blank"), since clearView() is deprecated now
            webView.freeMemory();
            webView.destroy();
//            webView.pauseTimers();
            webView = null; // Note that mWebView.destroy() and mWebView = null do the exact same thing
        }
    }

    /**
     * 加载 BannerView
     */
    public void getBannerView() {
        mAdBean = mBannerView.adBean();
        if (mAdBean != null) {
            //判断是否是adm类型广告 走不同的加载逻辑
            if (TextUtils.isEmpty(mAdBean.getAdm())) {
                getAdxView();
            } else {
                getAdmView();
            }
        }
    }


    /**
     * 下载AdChoices
     */
    public void downloadAdChoice() {
        if (!TextUtils.isEmpty(mAdBean.getAdChoiceImageUrl())) {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"textView impression");
            ImageDownloadHelper.downloadImage(mAdBean.getAdChoiceImageUrl(), Constants.ImageLoadType.IMAGE_DISK_INCLUDED, mAdBean, AthenaTracker.M_TYPE_AD_CHOICE_VIEW, new ImageDownloadHelper.ImageListener() {
                @Override
                public void onImagesCached(byte[] data) {
                    mAdBean.setACReady(true);
                }

                @Override
                public void onImagesFailedToCache(TaErrorCode errorCode) {
                    mAdBean.setACReady(false);
                }
            });
        } else {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"Not found adChoiceImageUrl");
        }
    }

    /**
     * 展示广告
     */
    public void showAd() {
        if (null != mAdBean) {
            if (TextUtils.isEmpty(mAdBean.getAdm())) {
                showNormalAd();
            } else {
                Log.d(CommonLogUtil.TAG,"banner showAdm Ad");
                showAdmAd();
            }
        }
    }

    private void showNormalAd(){
        // Banner 大图地址
        String url = mAdBean.getAdImgUrl();
        int type = AthenaTracker.M_TYPE_LARGE_IMG;

        // 1.5 版本 适配没有大图只有logo的广告样式
        if (TextUtils.equals(mAdBean.getMaterialStyle(), Constants.BANNER_MATERIAL_STYLE_B20301)
                || TextUtils.equals(mAdBean.getMaterialStyle(), Constants.BANNER_MATERIAL_STYLE_B20302)
                || TextUtils.equals(mAdBean.getMaterialStyle(), Constants.BANNER_MATERIAL_STYLE_B20303)) {
            if (null != mAdBean.getPackageName()) {
                url = mAdBean.getNativeObject().getLogoUrl();
                type = AthenaTracker.M_TYPE_LOGO;
            }
        }

        // 这里怎么又重新下载了一次
        DownLoadRequest downLoadRequest = new DownLoadRequest().setListener(new DrawableResponseListener() {
            @Override
            public void onRequestSuccess(int statusCode, byte[] data, AdImage adMedia) {
                AdLogUtil.Log().d(CommonLogUtil.TAG,"bind drawable to imageView success");
                mBannerView.attachBannerToViewTree(adMedia);
            }

            @Override
            protected void onRequestError(TaErrorCode adError) {
                AdLogUtil.Log().d(CommonLogUtil.TAG,"bind drawable to imageView failed, code: " + adError.getErrorCode() + ",message:" + adError.getErrorMessage());
            }
        }).setUrl(url).setAdsDTO(mAdBean, type);
        downLoadRequest.netRequestPreExecute();
    }

    private void showAdmAd() {
        if (webView != null) {
            mBannerView.attachBannerToViewTree(webView);
        }
    }

    /**
     * 获取Adx banner广告数据(缓存数据)
     */
    private void getAdxView(){
        // 需要考虑 没有大图 只有logo的 Banner 广告样式
        // Banner 大图地址
        String url = mAdBean.getAdImgUrl();
        int type = AthenaTracker.M_TYPE_LARGE_IMG;
        if (TextUtils.equals(mAdBean.getMaterialStyle(), Constants.BANNER_MATERIAL_STYLE_B20301)
                || TextUtils.equals(mAdBean.getMaterialStyle(), Constants.BANNER_MATERIAL_STYLE_B20302)
                || TextUtils.equals(mAdBean.getMaterialStyle(), Constants.BANNER_MATERIAL_STYLE_B20303)) {
            // 没有Banner 大图的 下载logo 图片
            if (null != mAdBean.getNativeObject()) {
                url = mAdBean.getNativeObject().getLogoUrl();
                type = AthenaTracker.M_TYPE_LOGO;
            }
        }

        if (!TextUtils.isEmpty(url)) {

            //SLogUtil.Log().d(AdLogUtil.TAG,"imageview impression");
            ImageDownloadHelper.downloadImage(url, Constants.ImageLoadType.IMAGE_DISK_INCLUDED, mAdBean, type, new ImageDownloadHelper.ImageListener() {
                @Override
                public void onImagesCached(byte[] data) {
                    if (mBannerView.adListener() != null) {
                        mBannerView.adListener().onAdLoaded();
                    }
                }

                @Override
                public void onImagesFailedToCache(TaErrorCode errorCode) {
                    if (mBannerView.adListener() != null) {
                        mBannerView.adListener().onError(errorCode);
                    }
                }
            });
            //预加载AdChoiceImgUrl
            if(!DownLoadRequest.IS_HAD_AD_CHOICE){
                downloadAdChoice();
            }
        } else {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"Not found the render type");
        }
    }
    /**
     * 获取Adm banner广告数据（缓存数据）
     */
    private void getAdmView(){
        if (!NetUtil.checkNetworkState()) {
            return;
        }
        if (mAdBean == null){
            return;
        }
        String adm = mAdBean.getAdm();
        if (TextUtils.isEmpty(adm)){
            AdLogUtil.Log().e(CommonLogUtil.TAG,"BannerGemini getAdmView,adm is null");
            mBannerView.adListener().onError(RESPONSE_AD_IS_EMPTY);
            return;
        }
        List<String> scales = mAdBean.getScales();
        //判断adm的尺寸是否是20：3 、3：2
        if (scales == null || scales.size() == 0) {
            mBannerView.adListener().onError(ADM_SCALE_NOT_FIT);
            return;
        } else {
            String scale = scales.get(0);
            switch (scale){
                case BANNER_SCALE_203:
                case BANNER_SCALE_32:
                    break;
                default:
                    mBannerView.adListener().onError(ADM_SCALE_NOT_FIT);
                    AdLogUtil.Log().e(CommonLogUtil.TAG,"BannerGemini adm scale is not fit");
                    return;
            }
        }
        AdLogUtil.Log().d(CommonLogUtil.TAG, "BannerGemini getAdmView");
        webView = new TadmWebView(CoreUtil.getContext());
        webView.setWebViewClient(new WebViewClient(){
            boolean isRequestFailed = false;

            @Override
            public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
                if (url ==null){
                    return super.shouldInterceptRequest(view,url);
                }
                if (url.contains(TrackingManager.AUCTION_PRICE)
                        && (url.startsWith("http") || url.startsWith("https"))) {
                    AdLogUtil.Log().d(CommonLogUtil.TAG,"BannerGemini shouldInterceptRequest,show url is " + url);
                    if (mAdBean.getShowTrackingUrls() == null){
                        mAdBean.setShowTrackingUrls(new ArrayList<String>());
                    }
                    mAdBean.getShowTrackingUrls().add(url);
                    WebResourceResponse webResourceResponse = new WebResourceResponse("text/html", "utf-8",new ByteArrayInputStream("".getBytes()));
                    return webResourceResponse;
                }
                return super.shouldInterceptRequest(webView,url);
            }


            @Override
            public void onPageFinished(WebView view, String url) {
                // onPageFinished在重定向的情况下是有可能调用多次的
                // && view!=null && view.getProgress() == 100 添加双重判断
                if (mBannerView.adListener() != null && view!=null && view.getProgress() == 100) {
                    if (isRequestFailed) {
                        AdLogUtil.Log().d(CommonLogUtil.TAG,"BannerGemini onPageFinished,isRequestFailed is true");
                        mBannerView.adListener().onError(new TaErrorCode(PARSE_BITMAP_ERROR,
                                "download resource error"));
                        AthenaTracker.trackImageDownload(mAdBean,AthenaTracker.DOWNLOAD_WAY_HTTP_URL_CONNECTION,AthenaTracker.M_STATUS_ERROR,"",AthenaTracker.M_TYPE_LARGE_IMG);
                    } else {
                        AdLogUtil.Log().d(CommonLogUtil.TAG,"BannerGemini onPageFinished,isRequestFailed is false");
                        mBannerView.adListener().onAdLoaded();
                        AthenaTracker.trackImageDownload(mAdBean,AthenaTracker.DOWNLOAD_WAY_HTTP_URL_CONNECTION,AthenaTracker.M_STATUS_SUCCESS,"",AthenaTracker.M_TYPE_LARGE_IMG);
                    }
                }
            }
            @Override
            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                isRequestFailed = true;
                super.onReceivedHttpError(view, request, errorResponse);
                if (null != request){
                    AdLogUtil.Log().e(CommonLogUtil.TAG,"BannerGemini onReceivedHttpError "+request.getUrl());
                } else {
                    AdLogUtil.Log().e(CommonLogUtil.TAG,"BannerGemini onReceivedHttpError,request is null");
                }
            }

            @Override
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                isRequestFailed = true;
                if (null != request){
                    AdLogUtil.Log().e(CommonLogUtil.TAG,"BannerGemini onReceivedError "+request.getUrl());
                } else {
                    AdLogUtil.Log().e(CommonLogUtil.TAG,"BannerGemini onReceivedError,request is null");
                }
            }
        });
        String html = adm.replace("<img", "<img style=\"max-width:100%;max-height: 100%;\"");
        webView.loadData(html,"text/html","utf-8");
        AdLogUtil.Log().d(CommonLogUtil.TAG,"BannerGemini getAdmView " +adm);
        AthenaTracker.trackImageDownload(mAdBean,AthenaTracker.DOWNLOAD_WAY_HTTP_URL_CONNECTION,AthenaTracker.M_STATUS_STAR,"",AthenaTracker.M_TYPE_LARGE_IMG);
    }
}
