package com.cloud.hisavana.sdk.common.ps;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.recyclerview.widget.RecyclerView;

import com.cloud.hisavana.sdk.R;

import java.util.List;

/**
 * Created by wenjing.luo on 2022/03/28.
 * ps中间页gplinklist的adapter
 */

public class GpLinkRecyclerAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private LayoutInflater mLayoutInflater;
    public List<String> data;

    public GpLinkRecyclerAdapter(Context context, List<String> data) {
        this.data = data;
        mLayoutInflater = LayoutInflater.from(context);
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(mLayoutInflater.inflate(R.layout.item_ad_ps_gplink, parent, false));
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        PsRequestManager.renderImageView(data.get(position), ((ViewHolder) holder).imageView,((ViewHolder) holder).imageView_hori);
    }

    class ViewHolder extends RecyclerView.ViewHolder {
        public ImageView imageView;
        public ImageView imageView_hori;

        public ViewHolder(View itemView) {
            super(itemView);
            imageView = itemView.findViewById(R.id.imageView);
            imageView_hori = itemView.findViewById(R.id.imageView_hori);
        }
    }

    @Override
    public int getItemCount() {
        return data.size();
    }

}
