package com.cloud.hisavana.sdk.common.widget;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;

public class TadmWebView extends WebView {

    public TadmWebView(@NonNull Context context) {
        super(context);
        initSetting();
    }

    public TadmWebView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        initSetting();
    }

    public TadmWebView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initSetting();
    }

    private void initSetting(){
        setBackgroundColor(0);
        WebSettings webSettings = getSettings();
        webSettings.setJavaScriptEnabled(true);
        //等比例缩放
//        webSettings.setUseWideViewPort(true);
        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        webSettings.setSupportZoom(true);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            webSettings.setMediaPlaybackRequiresUserGesture(false);
        }
//        webSettings.setBuiltInZoomControls(true);
        webSettings.setUseWideViewPort(false);
//        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        webSettings.setLoadWithOverviewMode(true); //可以去除，关键需要html片段中的img添加max-width = 100%
        setWebChromeClient(new WebChromeClient(){
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
            }

        });
        //SMALLEST(50%),SMALLER(75%),NORMAL(100%),LARGER(150%),LARGEST(200%);
    }
    @Override
    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        scrollTo(0,0);
    }
}
