package com.cloud.hisavana.sdk.internal.base;

import android.text.TextUtils;

import com.cloud.hisavana.sdk.BuildConfig;
import com.cloud.hisavana.sdk.ad.base.AdxDefault;
import com.cloud.hisavana.sdk.api.request.AdRequest;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.callback.InternalAdListener;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.internal.detach.AdInfoTransfer;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.cloud.sdk.commonutil.util.RunTimer;
import com.transsion.core.utils.NetUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by jianbing.yu on 2019/3/29.
 * <p>
 * 插屏 Banner native
 */
public abstract class BaseAd {

    protected String mPlacementId;
    protected int requestType;
    protected boolean isDefaultAd = false;
    protected int scheduleTime = 60 * 1000;//default 60s
    /**
     * 超时相关
     */
    private final RunTimer runTimer = new RunTimer();

    protected boolean isTimeout = false; // 超时标志 --> 即使后面请求回来了 也不执行后面的业务逻辑了
    protected AdListener mListener;
    protected String mRid = "";
    protected AdRequest adRequest;

    public static final int LOAD = 1;
    public static final int RESPONSE = 2;
    public static final int FINISHED = 3;
    protected int mStep = LOAD;

    public String mSdkVersion = "";

    protected boolean mLoaded = false; // load成功
    protected boolean mShowed = false; // show成功
    public boolean mClicked = false; // click成功

    protected boolean oneByOne = false;
    protected String mRequestId;

    protected AtomicInteger adShowCount = new AtomicInteger(1);

    public void setAdRequest(AdRequest request) {
        if (request == null) {
            return;
        }
        this.adRequest = request;
        if (!TextUtils.isEmpty(request.getRequestId())) {
            this.mRequestId = request.getRequestId();
        }
        if (!TextUtils.isEmpty(request.getPlacementId())) {
            this.mPlacementId = request.getPlacementId();
        }
        if (request.getListener() != null) {
            this.mListener = request.getListener();
        }
        if (request.getScheduleTime() > 0) {
            this.scheduleTime = request.getScheduleTime();
        }
        if (request.getRequestType() != -1) {
            this.requestType = request.getRequestType();
        }
        this.isDefaultAd = request.isDefault();
    }

    public void setScheduleTime(int scheduleTime){
        this.scheduleTime = scheduleTime;
    }

    public AdRequest getAdRequest() {
        return adRequest;
    }

    public void setRequestId(String requestId){
        this.mRequestId = requestId;
    }
    // =============================================================================================


    /**
     * 这个 监听器 设置给了 Adx 去请求广告 --> 拿到广告之后回调
     */
    protected InternalAdListener mInternalListener = new InternalAdListener() {

        @Override
        public void onAdResponse(List<AdsDTO> adBeanList) {
            if (adBeanList != null && adBeanList.size() > 0 && adBeanList.get(0) != null &&
                    adBeanList.get(0).getImpBeanRequest() != null) {
                adBeanList.get(0).getImpBeanRequest().isTimeOut = isTimeout ? 1 : 0;
            }
            super.onAdResponse(adBeanList);
            if (isTimeout) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "Request time out");
                return;
            }
            if (adBeanList == null && adBeanList.size() <= 0) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "adList is empty");
                return;
            }
            onAdResponseStub(adBeanList);
            //Adx Tracker, load ad success
            if (adBeanList.get(0) != null) {
                mRid = adBeanList.get(0).getRid();
                mStep = RESPONSE;
            }
        }

        @Override
        public void onSplashCacheGet(List<AdsDTO> adBeans) {
            if (isTimeout) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "Request time out");
                return;
            }
            onSplashCacheGetStub(adBeans);
        }

        @Override
        public void onAdLoaded() {
            if (isTimeout) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "Request time out");
                return;
            }
            if (runTimer != null) {
                runTimer.resetTimerTask();
            }
            onAdLoadedStub();
            mStep = FINISHED;
            mLoaded = true;

            if (mListener != null) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "onAdLoaded");
                mListener.onAdLoaded();
            }
        }

        @Override
        public void onAdLoaded(List<TaNativeInfo> nativeInfos) {
            if (isTimeout) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "Request time out");
                return;
            }
            if (runTimer != null) {
                runTimer.resetTimerTask();
            }
            onAdLoadedStub(nativeInfos);

            StringBuilder icon = new StringBuilder();
            StringBuilder image = new StringBuilder();
            for (TaNativeInfo nativeInfo : nativeInfos) {
                if (nativeInfo != null) {
                    icon.append(nativeInfo.getIconImage() != null && nativeInfo.getIconImage().isCached() ? "1" : "0");
                    image.append(nativeInfo.getImage() != null && nativeInfo.getImage().isCached() ? "1" : "0");
                    String mime = nativeInfo.getImage() != null ? nativeInfo.getImage().getMime() + "" : "1";
                    AdLogUtil.Log().d(CommonLogUtil.TAG, "Track_native_fill=" + mime);
                }
            }
            mStep = FINISHED;
            mLoaded = true;

            if (mListener != null && nativeInfos != null) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "onAdLoaded TadNativeInfos size is:=" + nativeInfos.size());
                List<TaNativeInfo> adInfos = AdInfoTransfer.getAdInfo(nativeInfos);
                if (adInfos != null && nativeInfos.size() > 0) {
                    mListener.onAdLoaded(adInfos);
                }
            }
        }

        @Override
        public void onError(TaErrorCode adError) {
            if (isTimeout) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "Request time out");
                return;
            }
            if (runTimer != null) {
                runTimer.resetTimerTask();
            }
            onErrorStub(adError);
            mStep = FINISHED;

            if (mListener != null) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "adError：=" + adError.getErrorMessage());
                mListener.onError(adError);
            }
        }

        @Override
        public void onErrorInternal(List<AdsDTO> adBeans, TaErrorCode adError, AdxImpBean adxImpBean) {
            adxImpBean.isTimeOut = isTimeout ? 1 : 0;
            super.onErrorInternal(adBeans, adError, adxImpBean);
            onError(adError);
        }

        @Override
        public void onAdClicked(DownUpPointBean pointBean) {
            onAdClickStub();
            mClicked = true;
            if (mListener != null) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "onAdClicked");
                mListener.onAdClicked(pointBean);
            }
        }

        @Override
        public void onAdClosed() {
            onAdClosedStub();
            if (mListener != null) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "onAdClosed");
                mListener.onAdClosed();
            }
        }

        @Override
        public void onAdShow() {
            onAdShowStub();
            adShowCount.decrementAndGet();
            if (mListener != null && !mShowed) {
                mShowed = adShowCount.get() <= 0;
                CommonLogUtil.Log().d(CommonLogUtil.TAG, "onAdShow");
                mListener.onAdShow();
            }
        }

        @Override
        public void onTimeOut() {
            onAdTimeoutStub();
        }

        @Override
        public void onMediaDownloaded(TaNativeInfo adInfo) {
            if (mListener != null) {
                AdLogUtil.Log().d(CommonLogUtil.TAG, "onMediaDownloaded");
                mListener.onMediaDownloaded(adInfo);
            }
        }
    };


    /**
     * 定义一套回调 给子类使用
     * 网络请求回来之后 回调给子类
     */
    protected void onAdClickStub() {
    }

    protected void onAdLoadedStub() {
    }

    protected void onAdLoadedStub(List<TaNativeInfo> nativeInfos) {
    }

    protected void onAdClosedStub() {
    }

    protected void onAdTimeoutStub() {
        isTimeout = true;
        mStep = FINISHED;

        if (mListener != null) {
            AdLogUtil.Log().d(CommonLogUtil.TAG, "onTimeOut");
            mListener.onTimeOut();
        }
    }

    protected void onSplashCacheGetStub(List<AdsDTO> adBeans) {
    }

    protected void onErrorStub(TaErrorCode adError) {
    }

    protected void onAdShowStub() {
    }

    protected void onAdResponseStub(List<AdsDTO> adBeanList) {

    }


    // =============================================================================================


    public BaseAd(int adType, String placementId) {
        this.mPlacementId = placementId;
        mSdkVersion = BuildConfig.VERSION_NAME;
    }


    // =============================================================================================


    public abstract void setPlacementId(String placementId);

    public void setRequestType(int requestType) {
        this.requestType = requestType;
    }

    /**
     * 加载广告 各自子类实现加载 --> Adx 加载
     *
     * @return
     */
    protected abstract boolean loadPolyAd();

    //获取广告类型
    public abstract int getAdType();

    public String placementId() {
        return mPlacementId;
    }

    public void setDefaultAd(boolean defaultAd) {
        isDefaultAd = defaultAd;
    }

    public InternalAdListener adListener() {
        return mInternalListener;
    }

    public void setListener(AdListener listener) {
        this.mListener = listener;
    }

    // =============================================================================================

    public void loadAd(String requestId) {
        this.mRequestId = requestId;
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                if (isDefaultAd) {
                    //请求打底广告
                    loadDefaultAd();
                } else {
                    loadAdInternal();
                }
            }
        });
    }

    public void loadAd() {
        mRequestId = DeviceUtil.getUUID();
        loadAd(mRequestId);
    }

    public void loadAdInternal() {

        if (!NetUtil.checkNetworkState()) {
            if (mInternalListener != null) {
                mInternalListener.onError(TaErrorCode.NETWORK_ERROR);
            }
            return;
        }

        if (loadPolyAd()) {
            resetFlag();
            mStep = LOAD;
            runTimerTask();
        }
    }

    public void setShowCount(int showCount){
        if(showCount ==0){
            showCount = 1;
        }
        if (adShowCount != null) {
            adShowCount.set(showCount);
        }
    }

    /**
     * 加载打底广告
     */
    private void loadDefaultAd() {
        // 从缓存中获取打底广告数据
        List<AdsDTO> adItems = AdxDefault.getDefaultAdItem(mPlacementId, true);
        if (mListener != null) {
            if (adItems != null && adItems.size() > 0 && adItems.get(0) != null
                    //判断广告类型是否一样
                    && adItems.get(0).getCodeSeatType() == getAdType()) {
                AdLogUtil.Log().d(CommonLogUtil.TAG,"onAdDefaultLoaded");
                List<AdsDTO> adBeanList = new ArrayList<>();
                adBeanList.add(adItems.get(0));
                onAdResponseStub(adBeanList);
            } else {
                AdLogUtil.Log().d(CommonLogUtil.TAG,"onAdDefaultLoadedError");
                mListener.onError(new TaErrorCode(100, "load default ad error"));
            }
        }
    }


    // =============================================================================================


    public void setOneByOne(boolean oneByOne) {
        this.oneByOne = oneByOne;
    }

    protected void onLoaded() {
        resetTimerTask();
        mStep = FINISHED;
        mLoaded = true;
    }

    private void resetFlag() {
        isTimeout = false;
        mLoaded = false;
        mShowed = false;
        mClicked = false;
    }

    /**
     * 启动定时器
     */
    protected void runTimerTask() {
        if (runTimer != null) {
            isTimeout = false;
            runTimer.resetTimerTask();
            runTimer.setTimeOutCallback(timeOutCallback);
            runTimer.setScheduleTime(scheduleTime);
            runTimer.runTimerTask();
        }
    }

    protected void resetTimerTask() {
        if (runTimer != null) {
            runTimer.resetTimerTask();
        }
    }

    /**
     * 超时回调
     */
    private final RunTimer.TimeOutCallback timeOutCallback = new RunTimer.TimeOutCallback() {
        @Override
        public void isTimeOut() {
            if (mInternalListener != null) {
                mInternalListener.onTimeOut();
            }
        }
    };

    public void destroy() {
        if (mStep == LOAD || mStep == RESPONSE) {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"request is being cancel,current step is:" + mStep);
            mStep = FINISHED;
        }
        resetTimerTask();
        resetFlag();
        mListener = null;
    }

}
