package com.cloud.hisavana.sdk.common.http;

import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.listener.ResponseBaseListener;
import com.transsion.core.utils.NetUtil;

/**
 * Created by peng.sun on 2017/6/19.
 */

public abstract class RequestBase<T extends ResponseBaseListener> {

    protected final int TIMEOUT_IN_MILLIONS = 15 * 1000;
    protected T mListener = null;

    public void cancelRequest() {
        if (mListener != null) {
            mListener = null;
        }
    }
    /**
     * 前期执行检查网络
     */
    public void netRequestPreExecute() {
        if (!NetUtil.checkNetworkState()) { //断网
            if(mListener != null){
                mListener.onServerRequestFailure(TaErrorCode.NETWORK_ERROR);
            }
            return;
        }
        /**
         * 分发网络请求
         */
        netRequestPosExecute();
    }


    /**
     * 子类自身的网络请求
     */

    protected abstract void netRequestPosExecute();

}
