package com.cloud.hisavana.sdk.common.tranmeasure;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import com.transsion.core.CoreUtil;

/**
 * 监控屏幕的使用状态
 */
public class ScreenStateManager {

    private BroadcastReceiver mBroadcastReceiver;
    private boolean mIsScreenOff;
    private boolean mIsActive;
    private IState mStateListener;

    interface IState {
        void updateState(boolean forground);
    }

    protected void startMonitor() {
        registerBroadcast();
        this.mIsActive = true;
    }

    protected void setStateListener(IState state) {
        this.mStateListener = state;
    }

    private void stateChange(boolean screenOff) {
        if (this.mIsScreenOff != screenOff) {
            this.mIsScreenOff = screenOff;
            if (this.mIsActive && this.mStateListener != null) {
                this.mStateListener.updateState(isForground());
            }
        }
    }

    private boolean isForground() {
        return !this.mIsScreenOff;
    }

    private void registerBroadcast() {
        this.mBroadcastReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent != null) {
                    if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                        stateChange(true);
                    } else if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                        stateChange(false);
                    } else if ("android.intent.action.SCREEN_ON".equals(intent.getAction())) {
                        KeyguardManager keyguardManager = (KeyguardManager) context.getSystemService(Context.KEYGUARD_SERVICE);
                        if (keyguardManager != null && !keyguardManager.inKeyguardRestrictedInputMode()) {
                            stateChange(false);
                        }
                    }
                }
            }
        };
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        CoreUtil.getContext().registerReceiver(this.mBroadcastReceiver, intentFilter);
    }

    protected void endMonitor() {
        if (this.mBroadcastReceiver != null) {
            CoreUtil.getContext().unregisterReceiver(this.mBroadcastReceiver);
            this.mBroadcastReceiver = null;
        }
        this.mIsActive = false;
        this.mIsScreenOff = false;
        this.mStateListener = null;
    }

}
