package com.cloud.hisavana.sdk.internal.banner;

import static com.cloud.hisavana.sdk.common.constant.Constants.BANNER_SCALE.BANNER_SCALE_203;
import static com.cloud.hisavana.sdk.common.constant.Constants.BANNER_SCALE.BANNER_SCALE_32;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextPaint;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.ad.AdxBannerView;
import com.cloud.hisavana.sdk.ad.base.PlatformUtil;
import com.cloud.hisavana.sdk.api.config.AdsConfig;
import com.cloud.hisavana.sdk.common.adapter.IBanner;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.tranmeasure.AdImpressionListenerImpl;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSession;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSessionManager;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.widget.ViewGestureDetector;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.internal.base.BaseAd;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.ScreenUtil;

import java.util.List;

/**
 * Created by jianbing.yu on 2019/2/25.
 */

public class TranBanner extends BaseAd {

    BannerGemini mBannerPlatform;
    private AdsDTO mAdBean = null;
    private final ViewGroup mViewGroup;
    private final Context mContext;
    private View mRenderView = null;
    private IBanner mBanner;
    // adm广告手势监视器
    private final ViewGestureDetector gestureDetector = new ViewGestureDetector(CoreUtil.getContext());

//    private PsRequestManager psRequestManager;
    /**
     * 埋点 坐标点
     */
    private float downX = -1;
    private float downY = -1;
    private float upX = -1;
    private float upY = -1;

    private long oldTime;

    // =============================================================================================


    @Override
    protected void onAdResponseStub(List<AdsDTO> adBeanList) {
        if (mAdBean != null) {
            MeasureSessionManager.getInstance().destroySession(mAdBean);
        }
        mAdBean = adBeanList.get(0);
        if (mAdBean == null) {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"mAdBean is null,terminate flow");
            return;
        }
        //获取ps中间页素材
//        psRequestManager = new PsRequestManager(mAdBean);
//        psRequestManager.getRecommendItemIist();
        AdLogUtil.Log().d(CommonLogUtil.TAG,"*----> banner adPsType is " + mAdBean.getAdPsType());

        loadPlatformAd();
    }


    /**
     * 渲染Banner界面
     */
    private void loadPlatformAd() {
        mBannerPlatform.getBannerView();
        AdLogUtil.Log().d(CommonLogUtil.TAG,"start load ad");
    }

    /**
     * 曝光测量 回调
     */
    private final MeasureSession.AdImpressionListener impressionListener = new AdImpressionListenerImpl() {
        @Override
        public void onViewImpressed(AdsDTO adBean) {
            super.onViewImpressed(adBean);
            AdLogUtil.Log().d(CommonLogUtil.TAG,"view has impression,start report track---------------------------------");
            if (adListener() != null) {
                adListener().onAdShow();
            }
        }
    };


    // =============================================================================================


    public TranBanner(Context context, ViewGroup viewGroup, String placementId) {
        super(Constants.AdType.BANNER, placementId);
        this.mViewGroup = viewGroup;
        this.mContext = context.getApplicationContext();

        mBanner = new AdxBannerView(placementId);
        mBanner.setAdListener(mInternalListener);
        mBannerPlatform = new BannerGemini(this);
    }


    // =============================================================================================


    @Override
    public void setPlacementId(String placementId) {
        this.mPlacementId = placementId;
        mBanner.setPlacementId(placementId);
    }

    @Override
    protected boolean loadPolyAd() {
        if (mBanner.loadAd(mRequestId,requestType)) {
            if (mViewGroup != null) {
                mViewGroup.removeAllViews();
            }
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {

                if (ivBanner != null) {
                    if (ivBanner.getDrawable() != null) {
                        if (ivBanner.getDrawable() instanceof BitmapDrawable) {
                            BitmapDrawable bd = (BitmapDrawable) ivBanner.getDrawable();
                            if (bd != null) {
                                Bitmap bitmap = bd.getBitmap();
                                if (bitmap != null && !bitmap.isRecycled()) {
                                    bitmap.recycle();
                                }
                            }
                            ivBanner.setImageDrawable(null);
                        } else if (ivBanner.getDrawable() instanceof Drawable) {
                            ivBanner.setImageDrawable(null);
                        }
                    }
                }
                //如果有webview 销毁
                mBannerPlatform.destroy();
                mBanner.destroy();
                TranBanner.super.destroy();
                if (mViewGroup != null) {
                    mViewGroup.removeAllViews();
                }
                MeasureSessionManager.getInstance().destroySession(mAdBean);
            }
        });
    }

    @Override
    public int getAdType() {
        return Constants.AdType.BANNER;
    }


    // =============================================================================================


    AdsDTO adBean() {
        return mAdBean;
    }

    IBanner polyBanner() {
        return mBanner;
    }

    /**
     * 展示回调
     */
    public void show() {
        Preconditions.checkIsOnMainThread();
        if (mViewGroup == null || mAdBean == null) {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"mViewGroup or mAdBean = null");
            return;
        }
        boolean isAdValid = isAdValid();
        //打底广告是否有效，是看打底广告的有效期
        if (isDefaultAd) isAdValid = true;
        if (isAdValid && !mShowed) {
            doImpressionLogic();
        } else if (isAdValid) {
            mShowed = false;
            MeasureSessionManager.getInstance().destroySession(mAdBean);
            doImpressionLogic();
        } else {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"ad not condition to use");
        }
    }

    public boolean isLoaded() {
        return mLoaded;
    }

    // =============================================================================================


    ImageView ivBanner;

    /**
     * 在这里开始 组装 View
     *
     * @param adImage
     */
    void attachBannerToViewTree(AdImage adImage) {

        if (mAdBean == null || mViewGroup == null) {
            return;
        }

        mViewGroup.removeAllViews();
        ((RelativeLayout) mViewGroup).setGravity(Gravity.CENTER);

        if (null == mAdBean.getNativeObject() || null == mAdBean.getMaterialStyle()) {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"TranBanner --> null == mAdBean.nativeBean || null == mAdBean.materialStyle");
            return;
        }

        AdLogUtil.Log().d(CommonLogUtil.TAG,"*----> TranBanner --> MaterialStyle =" + mAdBean.getMaterialStyle());

        // 显示不同的布局
        switch (mAdBean.getMaterialStyle()) {
            case Constants.BANNER_MATERIAL_STYLE_B3201:
                mRenderView = LayoutInflater.from(mViewGroup.getContext())
                        .inflate(R.layout.banner_style_3201_layout, mViewGroup, false);
                break;

            // 没有主图的Banner样式
            case Constants.BANNER_MATERIAL_STYLE_B20301:
            case Constants.BANNER_MATERIAL_STYLE_B20302:
            case Constants.BANNER_MATERIAL_STYLE_B20303:
                mRenderView = LayoutInflater.from(mViewGroup.getContext())
                        .inflate(R.layout.banner_style_20301_20302_20303_layout, mViewGroup, false);
                // 点击事件
                mRenderView.findViewById(R.id.clRoot).setOnTouchListener(new TAdOnTouchListener());
                mRenderView.findViewById(R.id.clRoot).setOnClickListener(new TAdImageOnClickListener());
                break;

            case Constants.BANNER_MATERIAL_STYLE_B20304:
                mRenderView = LayoutInflater.from(mViewGroup.getContext())
                        .inflate(R.layout.banner_style_20304_layout, mViewGroup, false);
                break;

            default:
                AdLogUtil.Log().d(CommonLogUtil.TAG,"TranBanner --> 没有匹配到 materialStyle --> 配置错误 materialStyle=" + mAdBean.getMaterialStyle());
                return;
        }

        // 在这里 添加到测量队列里面
        MeasureSession session = MeasureSessionManager.getInstance().getMeasureSession(mAdBean);
        session.setAdValid(AdsConfig.isAdValid(mAdBean));
        session.registerView(mRenderView, impressionListener);

        // F20301 F20302 F20303 使用的
        switch (mAdBean.getMaterialStyle()) {
            case Constants.BANNER_MATERIAL_STYLE_B20301:
                mRenderView.<TextView>findViewById(R.id.tvName).setText(mAdBean.getNativeObject().getTitleTxt());
                mRenderView.<TextView>findViewById(R.id.tvDescription).setText(mAdBean.getNativeObject().getDescriptionTxt());
                mRenderView.<TextView>findViewById(R.id.tvBtn).setText(mAdBean.getNativeObject().getButtonTxt(mAdBean.getInstallApk()));
                break;

            case Constants.BANNER_MATERIAL_STYLE_B20302:
                mRenderView.<TextView>findViewById(R.id.tvName).setText(mAdBean.getNativeObject().getTitleTxt());
                mRenderView.<TextView>findViewById(R.id.tvBtn).setText(mAdBean.getNativeObject().getButtonTxt(mAdBean.getInstallApk()));
                mRenderView.<TextView>findViewById(R.id.tvDescription).setVisibility(View.GONE);
                break;

            case Constants.BANNER_MATERIAL_STYLE_B20303:
                // tvName 与 tvDescription 互换
                mRenderView.<TextView>findViewById(R.id.tvDescription).setText(mAdBean.getNativeObject().getTitleTxt());
                mRenderView.<TextView>findViewById(R.id.tvName).setText(mAdBean.getNativeObject().getDescriptionTxt());
                mRenderView.<TextView>findViewById(R.id.tvBtn).setText(mAdBean.getNativeObject().getButtonTxt(mAdBean.getInstallApk()));
                break;
        }

        // 字体加粗
        TextView viewById = mRenderView.findViewById(R.id.tvName);
        if (null != viewById && null != viewById.getPaint()) {
            TextPaint p = viewById.getPaint();
            p.setFakeBoldText(true);
        }

        // 有主图的布局 多布局都是这个id
        ivBanner = mRenderView.findViewById(R.id.ivBanner);
        if (null != ivBanner) {
            adImage.attachView(ivBanner);
            // 点击事件
            ivBanner.setOnTouchListener(new TAdOnTouchListener());
            ivBanner.setOnClickListener(new TAdImageOnClickListener());
        }

        // logo 图片
        ImageView ivIcon = mRenderView.findViewById(R.id.ivIcon);
        if (null != ivIcon) {
            adImage.attachView(ivIcon);
        }

        // 当前广告的 adChoices
        ImageView flAdChoices = mRenderView.findViewById(R.id.ivAdChoices);
        if (null != flAdChoices) {
            ImageDownloadHelper.loadImageView(mAdBean.getAdChoiceImageUrl(),
                    flAdChoices, mAdBean, AthenaTracker.M_TYPE_AD_CHOICE_VIEW, null);
        }
        //adchoiceview设置点击事件
        flAdChoices.setOnClickListener(new AdChoiceViewOnClickListener());

        // 加载 布局样式
        mViewGroup.addView(mRenderView,
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT);

        if (mViewGroup.getBackground() != null) {
            mViewGroup.getBackground().setAlpha(0);
        }

        mViewGroup.setVisibility(View.VISIBLE);
        AdLogUtil.Log().d(CommonLogUtil.TAG,"ad banner show...");
    }

    /**
     * 把webview add到展示banner view上
     * @param webView
     */
    void attachBannerToViewTree(WebView webView){
        mViewGroup.removeAllViews();
        ((RelativeLayout) mViewGroup).setGravity(Gravity.CENTER);
        if (webView == null){
            return;
        }
        mRenderView = webView;
        // 在这里 添加到测量队列里面
        MeasureSession session = MeasureSessionManager.getInstance().getMeasureSession(mAdBean);
        session.setAdValid(AdsConfig.isAdValid(mAdBean));
        session.registerView(mRenderView, impressionListener);
        // 添加手势管理
        mRenderView.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                gestureDetector.onTouchEvent(event);
                switch (event.getAction()){
                    case MotionEvent.ACTION_DOWN:
                        downX = event.getX();
                        downY = event.getY();
                        break;
                    case MotionEvent.ACTION_UP:
                        upX = event.getX();
                        upY = event.getY();
                        break;
                }
                return false;
            }
        });
        webView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                if (gestureDetector.isClicked()) {
                    AdLogUtil.Log().d(CommonLogUtil.TAG,"banner adm shouldOverrideUrlLoading");
                    gestureDetector.setClicked(false);
                    try {
                        if (request == null) {
                            return true;
                        }
                        Uri uri = request.getUrl();
                        if (uri == null) {
                            return true;
                        }
                        mAdBean.setClickUrl(uri.toString());
                        polyBanner().startLandingPage(view.getContext(),
                                mAdBean, new DownUpPointBean(downX, downY, upX, upY,
                                        view.getMeasuredHeight(), view.getMeasuredWidth()));
                        AdLogUtil.Log().d(CommonLogUtil.TAG, "TranBanner shouldOverrideUrlLoading " +
                                "start landingPage,url is " + uri);
                        if (adListener() != null) {
                            adListener().onAdClicked(new DownUpPointBean(downX, downY, upX, upY,
                                    view.getMeasuredHeight(), view.getMeasuredWidth()));
                        }
                    } catch (Exception exception) {
                        AdLogUtil.Log().e(CommonLogUtil.TAG, "TranBanner attachBannerToViewTree" +
                                " ex " + exception);
                    }
                    return true;
                }
                return false;
            }
        });
        // 加载 布局样式
        mViewGroup.addView(mRenderView,
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.MATCH_PARENT);
        mRenderView = LayoutInflater.from(mViewGroup.getContext())
                .inflate(R.layout.banner_style_3201_layout, mViewGroup, false);
        mViewGroup.addView(mRenderView);
        ImageView icon = mRenderView.findViewById(R.id.ivIcon);
        ImageView adChoice = mRenderView.findViewById(R.id.ivAdChoices);
        if (icon != null && mAdBean !=null && mAdBean.getNativeObject().getLogoUrl()!=null){
            ImageDownloadHelper.loadImageView(mAdBean.getNativeObject().getLogoUrl(),
                    icon, mAdBean, AthenaTracker.M_TYPE_LOGO, null);
        }
        if (adChoice != null && mAdBean != null) {
            ImageDownloadHelper.loadImageView(mAdBean.getAdChoiceImageUrl(),
                    adChoice, mAdBean, AthenaTracker.M_TYPE_AD_CHOICE_VIEW, null);
            adChoice.setOnClickListener(new AdChoiceViewOnClickListener());
        }
        List<String> scales = adBean().getScales();
        if (null != scales && scales.size()>0){
            switch (scales.get(0)){
                case BANNER_SCALE_203:
                    webView.getLayoutParams().height = ScreenUtil.getWinWidth() * 3 / 20;
                    webView.getLayoutParams().width = ScreenUtil.getWinHeight();
                    break;
                case BANNER_SCALE_32:
                    webView.getLayoutParams().height = ScreenUtil.getWinHeight() * 2 /3;
                    webView.getLayoutParams().width = ScreenUtil.getWinWidth();
                    break;
                default:
                    break;
            }
        }
        webView.setVisibility(View.VISIBLE);
        AdLogUtil.Log().d(CommonLogUtil.TAG,"banner attachBannerToViewTree");
        if (mViewGroup.getBackground() != null) {
            mViewGroup.getBackground().setAlpha(0);
        }
        mViewGroup.setVisibility(View.VISIBLE);
    }

    public boolean isAdValid() {
        return AdsConfig.isAdValid(mAdBean);
    }

    public double getBidPrice() {
        if (mAdBean != null) {
            return mAdBean.getFirstPrice();
        }
        return 0;
    }
    public String getDefaultAdRequestId() {
        if (mAdBean != null) {
            return mAdBean.getRid();
        }
        return "";
    }

    public void setSecondPrice(double secondPrice){
        if (mAdBean != null) {
            mAdBean.setSecondPrice(secondPrice);
        }
    }
    private void doImpressionLogic() {
        if (mLoaded && mAdBean != null) {
            mBannerPlatform.showAd();
        } else {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"no ad show, set visible gone");
            mViewGroup.setVisibility(View.GONE);
        }
    }


    // =============================================================================================

    /**
     * 点击事件处理 跳转到落地页
     */
    private class TAdOnTouchListener implements View.OnTouchListener {

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    downX = event.getX();
                    downY = event.getY();
                    break;

                case MotionEvent.ACTION_UP:
                    upX = event.getX();
                    upY = event.getY();
                    break;

            }
            return false;
        }
    }
    //AdChoiceView点击事件
    private class AdChoiceViewOnClickListener implements View.OnClickListener {
        @Override
        public void onClick(View view) {
            if (mAdBean != null) {
                PlatformUtil.startPageByWebView(view.getContext(),mAdBean);
            }
        }
    }
    private class TAdImageOnClickListener implements View.OnClickListener {
        @Override
        public void onClick(View view) {
            asyncAction(view);
        }
    }

    private void asyncAction(View view) {
        try {
            if (mAdBean != null) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - oldTime > 2 * 1000) {  //防止重复点击
                    //1.4.0ps中间页 2022年5月20日，141
//                    SLogUtil.Log().d(AdLogUtil.TAG,"*----> TranBanner asyncAction mAdBean.getAdPsType() = " + mAdBean.getAdPsType());
//                    if (mAdBean.getAdPsType() == Constants.AD_PS_TYPE.PS_MATERIAL_DOWNLOAD_SUCCESS && psRequestManager != null){
//                        psRequestManager.psAdDialog(view.getContext().getApplicationContext());
//                        //服务端点击上报
//                        TrackingManager.reportServerClick(new DownUpPointBean(downX, downY, upX, upY,
//                                view.getMeasuredHeight(), view.getMeasuredWidth()),mAdBean);
//                    }else {
                    polyBanner().startLandingPage(view.getContext(),
                            mAdBean, new DownUpPointBean(downX, downY, upX, upY,
                                    view.getMeasuredHeight(), view.getMeasuredWidth()));
//                    }
                    if (adListener() != null) {
                        adListener().onAdClicked(new DownUpPointBean(downX, downY, upX, upY,
                                view.getMeasuredHeight(), view.getMeasuredWidth()));
                    }
                    oldTime = currentTime;
                }
            }
        } catch (Throwable e) {
            AdLogUtil.Log().e(Log.getStackTraceString(e));
            e.printStackTrace();
        }
    }

}
