/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.http;

import android.text.TextUtils;
import android.util.Log;
import com.cloud.hisavana.sdk.common.a;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.RequestBase;
import com.cloud.hisavana.sdk.common.http.listener.CommonResponseListener;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.http.HttpClient;
import com.transsion.http.builder.PostJsonBuilder;
import com.transsion.http.impl.IHttpCallback;
import com.transsion.http.impl.StringCallback;

public class AdPSServerRequest
extends RequestBase<CommonResponseListener> {
    private String mUrl = "";
    private boolean mIsDebug = false;
    private IAdPostBody mPostBody = null;

    public AdPSServerRequest setPostBody(IAdPostBody postBody) {
        this.mPostBody = postBody;
        return this;
    }

    public AdPSServerRequest setListener(CommonResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public AdPSServerRequest setUrl(String url) {
        this.mUrl = url;
        return this;
    }

    public AdPSServerRequest setDebug(boolean isDebug) {
        this.mIsDebug = isDebug;
        return this;
    }

    @Override
    protected void netRequestPosExecute() {
        TranssionPoolManager.getInstance().addTask(new Runnable(){

            @Override
            public void run() {
                AdPSServerRequest.this.sendRequestToServer();
            }
        });
    }

    private void sendRequestToServer() {
        block5: {
            String postBodyString = this.mPostBody.getPostBody();
            if (TextUtils.isEmpty((CharSequence)postBodyString) && this.mListener != null) {
                ((CommonResponseListener)this.mListener).onServerRequestFailure(-1, "TextUtils.isEmpty(postBodyString) == true ", null);
            }
            try {
                final String str = "----- full url = " + this.mUrl + "\n ----- postBodyString = " + postBodyString.trim();
                if (!TextUtils.isEmpty((CharSequence)this.mUrl)) {
                    if (this.mListener != null) {
                        ((CommonResponseListener)this.mListener).onServerRequestStart(1);
                    }
                    ((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)HttpClient.postJson().log(this.mIsDebug)).content(postBodyString).connectTimeout(15000)).readTimeout(15000)).url(this.mUrl)).build().execute((IHttpCallback)new StringCallback(true){

                        public void onSuccess(int statusCode, String response) {
                            a.netLog((String)(str + "\n ----- status code = " + statusCode + "\n ----- response = " + response));
                            if (!TextUtils.isEmpty((CharSequence)response)) {
                                if (AdPSServerRequest.this.mListener != null) {
                                    ((CommonResponseListener)AdPSServerRequest.this.mListener).onServerRequestSuccess(statusCode, response);
                                }
                            } else {
                                if (AdPSServerRequest.this.mListener != null) {
                                    ((CommonResponseListener)AdPSServerRequest.this.mListener).onServerRequestFailure(TaErrorCode.HTTP_RESPONSE_ERROR.getErrorCode(), TaErrorCode.HTTP_RESPONSE_ERROR.getErrorMessage(), null);
                                }
                                a.netLog((String)"TextUtils.isEmpty(response) == true ,  response is null ");
                            }
                        }

                        public void onFailure(int statusCode, String response, Throwable throwable) {
                            if (null != throwable) {
                                a.netLog((String)(str + " ----- error statusCode = " + statusCode + " ----- error message = " + throwable.getMessage() + " ----- response = " + response));
                            }
                            if (AdPSServerRequest.this.mListener != null) {
                                ((CommonResponseListener)AdPSServerRequest.this.mListener).onServerRequestFailure(statusCode, response, throwable);
                            }
                        }
                    });
                }
            }
            catch (Throwable e2) {
                a.netLog((String)("AdPSServerRequest --> " + Log.getStackTraceString((Throwable)e2)));
                if (this.mListener == null) break block5;
                ((CommonResponseListener)this.mListener).onServerRequestFailure(new TaErrorCode(10000, e2.getMessage()));
            }
        }
    }

    public static interface IAdPostBody {
        public String getPostBody();
    }
}

