/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.http.listener;

import android.util.Log;
import com.cloud.hisavana.sdk.common.a;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.listener.ResponseBaseListener;
import com.cloud.sdk.commonutil.gsonutil.GsonUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class CommonResponseListener<E>
extends ResponseBaseListener {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String UTF8_BOM = "\ufeff";

    protected CommonResponseListener() {
    }

    protected abstract void onRequestSuccess(int var1, E var2);

    public void onServerRequestSuccess(int statusCode, String response) {
        this.parseResponse(statusCode, response);
    }

    private void parseResponse(final int statusCode, String responseString) {
        try {
            Type superclass = this.getClass().getGenericSuperclass();
            if (!(superclass instanceof ParameterizedType)) {
                throw new RuntimeException("Missing type parameter.");
            }
            ParameterizedType parameterized = (ParameterizedType)superclass;
            Type type = parameterized.getActualTypeArguments()[0];
            Object bean = null;
            try {
                bean = GsonUtil.fromJson((String)responseString, (Type)type);
            }
            catch (Exception e2) {
                Log.i((String)"zxb_log", (String)("e: " + Log.getStackTraceString((Throwable)e2)));
            }
            final Object final_bean = bean;
            if (this.handler != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        CommonResponseListener.this.onRequestSuccess(statusCode, final_bean);
                    }
                });
            } else {
                this.onRequestSuccess(statusCode, final_bean);
            }
        }
        catch (Throwable e3) {
            e3.printStackTrace();
            a.netLog((String)("CommonResponseListener --> \u89e3\u6790\u7f51\u7edc\u8bf7\u6c42\u6570\u636e\u5f02\u5e38 --> parseResponse --> catch " + Log.getStackTraceString((Throwable)e3)));
            this.onRequestError(TaErrorCode.AD_DATA_PARSE_RESPONSE_ERROR);
        }
    }

    private String getResponseString(byte[] stringBytes, String charset) throws UnsupportedEncodingException {
        String toReturn;
        String string2 = toReturn = stringBytes == null ? null : new String(stringBytes, charset);
        if (toReturn != null && toReturn.startsWith(UTF8_BOM)) {
            return toReturn.substring(1);
        }
        return toReturn;
    }
}

