package com.cloud.hisavana.sdk.api.adx;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.internal.banner.TranBanner;
import com.cloud.sdk.commonutil.util.CommonLogUtil;

/**
 * Created by jianbing.yu on 2019/2/22.
 */

public class TBannerView extends RelativeLayout {

    protected final TranBanner mBanner;


    // =============================================================================================

    public TBannerView(Context context, String placementId) {
        super(context);
        mBanner = new TranBanner(context, this, placementId);
    }

    /**
     * 构造方法
     *
     * @param context
     * @param attrs
     */
    public TBannerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /**
     * 构造方法
     *
     * @param context
     * @param attrs
     * @param defStyleAttr
     */
    public TBannerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        String placementId = null;
        TypedArray types = context.obtainStyledAttributes(attrs, R.styleable.AdBannerView);

        for (int n = 0; n < types.getIndexCount(); n++) {
            int attr = types.getIndex(n);
            if (attr == R.styleable.AdBannerView_placementId) {
                placementId = types.getString(attr);
            }
        }

        if (types.getIndexCount() > 0) {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"placementId=" + placementId);
        }

        types.recycle();
        mBanner = new TranBanner(context, this, placementId);
    }


    // =============================================================================================


    /**
     * 设置placementId
     *
     * @param placementId
     */
    public void setPlacementId(String placementId) {
        mBanner.setPlacementId(placementId);
    }

    public void show() {
        mBanner.show();
    }

    public void setListener(AdListener listener) {
        mBanner.setListener(listener);
    }

    public boolean isAdValid() {
        return mBanner.isAdValid();
    }

    public boolean isLoaded(){
        return mBanner.isLoaded();
    }

    public void loadAd() {
        mBanner.loadAd();
    }

    public void destroy() {
        mBanner.destroy();
    }

}
