package com.cloud.hisavana.sdk.common.http.listener;

import android.util.Log;

import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.sdk.commonutil.gsonutil.GsonUtil;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;


/**
 * Created by peng.sun on 2017/6/20.
 */

public abstract class CommonResponseListener<E> extends ResponseBaseListener {

    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String UTF8_BOM = "\uFEFF";

    protected CommonResponseListener() {
        super();
    }

    /**
     * 成功回调
     *
     * @param statusCode
     * @param response
     */
    protected abstract void onRequestSuccess(int statusCode, E response);

    public void onServerRequestSuccess(int statusCode, String response) {
        parseResponse(statusCode, response);
    }

    private void parseResponse(final int statusCode, final String responseString) {
        try {
            Type superclass = CommonResponseListener.this.getClass().getGenericSuperclass();
            if (!(superclass instanceof ParameterizedType)) {
                throw new RuntimeException("Missing type parameter.");
            }
            ParameterizedType parameterized = (ParameterizedType) superclass;
            Type type = parameterized.getActualTypeArguments()[0];


            E bean = null;
            try {
                bean = GsonUtil.fromJson(responseString, type);
            } catch (Exception e) {
                Log.i("zxb_log", "e: " + Log.getStackTraceString(e));
            }

            final E final_bean = bean;

            if (handler != null) {
                this.handler.post(new Runnable() {
                    @Override
                    public void run() {
                        onRequestSuccess(statusCode, final_bean);
                    }
                });
            } else {
                onRequestSuccess(statusCode, final_bean);
            }
        } catch (Throwable e) {
            e.printStackTrace();
            AdLogUtil.netLog("CommonResponseListener --> 解析网络请求数据异常 --> parseResponse --> catch " + Log.getStackTraceString(e));
            onRequestError(TaErrorCode.AD_DATA_PARSE_RESPONSE_ERROR);
        }
    }

    /**
     * 辅助方法不做修改
     *
     * @param stringBytes
     * @param charset
     * @return
     * @throws UnsupportedEncodingException
     */
    private String getResponseString(byte[] stringBytes, String charset) throws UnsupportedEncodingException {
        String toReturn = (stringBytes == null) ? null : new String(stringBytes, charset);
        if (toReturn != null && toReturn.startsWith(UTF8_BOM)) {
            return toReturn.substring(1);
        }
        return toReturn;
    }
}
