package com.cloud.hisavana.sdk.common.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;

import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsion.core.CoreUtil;

import java.io.File;

/**
 * 开屏高斯模糊背景缓存管理，存取以图片服务器url为key进行操作
 * 文件操作，注意SecurityException的捕获
 */
public class BlurBgUtils {
    private static final String BG_PATH = "ssp_splash_blurBg";

    public interface OnBlurFinishCallback {
        //在主线程回调
        void onBlurFinish();
    }

    public static boolean checkBlurBgExist(String url) {
        try {
            return new File(getBlurBgFileName(url)).exists();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String saveBlurBgToFile(Bitmap bitmap, String url) throws Exception {
        try {
            long start = System.currentTimeMillis();
            Bitmap blurBitmap = doBlur(bitmap);
            long currentTimeMillis = System.currentTimeMillis();
            long blurTime = currentTimeMillis - start;
            File cacheDir = new File(getBlurBgPath());
            String fileName = MD5Utils.toMd5(url);
            FileUtil.saveBitmapToFile(cacheDir, blurBitmap, fileName);
            blurBitmap.recycle();
            AdLogUtil.Log().d(CommonLogUtil.TAG,"BlurBgUtils saveBlurBgToFile save success, blur time = " +
                    blurTime + ", save time = " + (System.currentTimeMillis() - currentTimeMillis) + ", url = " + url);
            return getBlurBgPath() + File.separator + fileName;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean deleteBlurBgFromFile(String url) {
        if (checkBlurBgExist(url)) {
            try {
                File file = new File(getBlurBgFileName(url));
                boolean delete = file.delete();
                if (delete) {
                    AdLogUtil.Log().d(CommonLogUtil.TAG,"BlurBgUtils deleteBlurBgFromFile delete success, url = " + url);
                }
                return delete;
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static Bitmap doBlur(Bitmap bitmap) {
        return BitmapUtil.doBlur(bitmap, 6, false);
    }

    public static Bitmap getBlurBgBitmap(String url) {
        if (!TextUtils.isEmpty(url) && checkBlurBgExist(url)) {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"BlurBgUtils getBlurBgBitmap bitmap exist, no need to blur again, url = " + url);
            return BitmapFactory.decodeFile(getBlurBgFileName(url));
        }
        return null;
    }

    public static String getBlurBgFileName(String url) {
        return getBlurBgPath() + MD5Utils.toMd5(url);
    }

    public static String getBlurBgPath() {
        return CoreUtil.getContext().getCacheDir().getAbsolutePath() +
                File.separator + BG_PATH + File.separator;
    }
}
