package com.cloud.hisavana.sdk.common.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;

import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsion.core.utils.ScreenUtil;

public class ImageCompressUtil {

    public static Bitmap compressBytesArray(byte[] bitmapBytes) {
        if (bitmapBytes == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            AdLogUtil.Log().d(CommonLogUtil.TAG,"BlurBgUtils ImageCompressUtil compressBytesArray 图片原始大小："
                    + BitmapFactory.decodeByteArray(bitmapBytes, 0, bitmapBytes.length).getAllocationByteCount());
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray(bitmapBytes, 0, bitmapBytes.length, options);
        int toWidth = ScreenUtil.getWinWidth();

        if (options.outWidth == 0 || options.outHeight == 0 || toWidth == 0) {
            return BitmapFactory.decodeByteArray(bitmapBytes, 0, bitmapBytes.length);
        }
        AdLogUtil.Log().d(CommonLogUtil.TAG,"BlurBgUtils ImageCompressUtil compressBytesArray 原始图片的宽width：" + options.outWidth + "原始图片的高height：" + options.outHeight);

        int toHeight = options.outHeight * toWidth / options.outWidth;
        options.inSampleSize = options.outWidth / toWidth;
        options.outWidth = toWidth;
        options.outHeight = toHeight;

        //使用RGB_565减少图片大小
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        //释放内存，共享引用（21版本后失效）
        options.inPurgeable = true;
        options.inInputShareable = true;

        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeByteArray(bitmapBytes, 0, bitmapBytes.length, options);

        AdLogUtil.Log().d(CommonLogUtil.TAG,"BlurBgUtils ImageCompressUtil compressBytesArray  压缩后width：" + options.outWidth + "压缩后图片的高height：" + options.outHeight);
        AdLogUtil.Log().d(CommonLogUtil.TAG,"BlurBgUtils ImageCompressUtil compressBytesArray  bitmap压缩后图片内存大小：" + bitmap.getByteCount());

        return bitmap;
    }
}
