/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.PermissionUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileUtil {
    public static File getAppDateFilePath() {
        Context context = CoreUtil.getContext();
        if (PermissionUtil.lacksPermissions((String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"})) {
            return null;
        }
        return context.getExternalFilesDir(null);
    }

    public static File getAppDateCachePath() {
        Context context = CoreUtil.getContext();
        return context.getExternalCacheDir();
    }

    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        return new File(cachePath + File.separator + uniqueName);
    }

    public static void saveBitmapToFile(File dirFile, Bitmap bm, String fileName) throws IOException {
        if (dirFile == null || bm == null || TextUtils.isEmpty((CharSequence)fileName)) {
            return;
        }
        if (!dirFile.exists()) {
            dirFile.mkdir();
        }
        File myCaptureFile = new File(dirFile + File.separator + fileName);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(myCaptureFile));
        bm.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)bos);
        bos.flush();
        bos.close();
    }

    public static void saveBytesToFile(File dir, byte[] bytes, String fileName) throws IOException {
        if (dir == null || bytes == null || bytes.length == 0 || TextUtils.isEmpty((CharSequence)fileName)) {
            return;
        }
        if (!dir.exists()) {
            dir.mkdir();
        }
        File myCaptureFile = new File(dir + File.separator + fileName);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(myCaptureFile));
        bos.write(bytes);
        bos.flush();
        bos.close();
    }
}

