package com.cloud.hisavana.sdk.common.http;

import android.text.TextUtils;
import android.util.Log;

import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.listener.CommonResponseListener;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.http.HttpClient;
import com.transsion.http.impl.StringCallback;


/**
 * Created by luowenjing on 2022/3/25.
 * 请求ps素材
 */

public class AdPSServerRequest extends RequestBase<CommonResponseListener> {
    private String mUrl = "";
    private boolean mIsDebug = false;
    private IAdPostBody mPostBody = null;

    public AdPSServerRequest setPostBody(IAdPostBody postBody) {
        this.mPostBody = postBody;
        return this;
    }

    public AdPSServerRequest setListener(CommonResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public AdPSServerRequest setUrl(String url) {
        this.mUrl = url;
        return this;
    }

    public AdPSServerRequest setDebug(boolean isDebug) {
        this.mIsDebug = isDebug;
        return this;
    }

    @Override
    protected void netRequestPosExecute() {
        TranssionPoolManager.getInstance().addTask(new Runnable() {
            @Override
            public void run() {
                sendRequestToServer();
            }
        });
    }

    public interface IAdPostBody {
        String getPostBody();
    }

    /**
     * 发送数据
     */

    private void sendRequestToServer() {
        String postBodyString = mPostBody.getPostBody();
        if (TextUtils.isEmpty(postBodyString)) {
            if (mListener != null) {
                mListener.onServerRequestFailure(-1, "TextUtils.isEmpty(postBodyString) == true ", null);
            }
            //AdLogUtil.netLog("sendRequestToServer() --> TextUtils.isEmpty(postBodyString) == true ");
        }
        try {
            //AdLogUtil.netLog("full url:=" + mUrl);
            //AdLogUtil.netLog("postBodyString == ");
            //AdLogUtil.netLog(postBodyString.trim());
            // 日志简化
            final String str = "----- full url = " + mUrl + "\n ----- postBodyString = " + postBodyString.trim();

            if (!TextUtils.isEmpty(mUrl)) {
                if (mListener != null) {
                    mListener.onServerRequestStart(Constants.LoadType.NET);
                }
                HttpClient.postJson()  //必须方法体
                        .log(mIsDebug)
                        .content(postBodyString) //必须方法体，上传的String类型的数据文本，目前只提供上传String接口
                        .connectTimeout(TIMEOUT_IN_MILLIONS)   //网络连接超时时间，单位毫秒，非必须默认10s
                        .readTimeout(TIMEOUT_IN_MILLIONS)      //读取数据超时时间，单位毫秒，非必须默认10s
                        .url(mUrl)
                        .build()
                        .execute(new StringCallback(true) {
                                     @Override
                                     public void onSuccess(final int statusCode, String response) {
                                         //AdLogUtil.netLog("status code:=" + statusCode + "  mUrl =" + mUrl + "  response = ");
                                         //AdLogUtil.netLog(response);
                                         AdLogUtil.netLog(str
                                                 + "\n ----- status code = " + statusCode
                                                 + "\n ----- response = " + response);

                                         if (!TextUtils.isEmpty(response)) {
                                             if (mListener != null) {
                                                 mListener.onServerRequestSuccess(statusCode, response);
                                             }
                                         } else {
                                             if (mListener != null) {
                                                 mListener.onServerRequestFailure(TaErrorCode.HTTP_RESPONSE_ERROR.getErrorCode(), TaErrorCode.HTTP_RESPONSE_ERROR.getErrorMessage(), null);
                                             }
                                             AdLogUtil.netLog("TextUtils.isEmpty(response) == true ,  response is null ");
                                         }
                                     }

                                     @Override
                                     public void onFailure(int statusCode, String response, Throwable throwable) {
                                         if (null != throwable) {
                                             //AdLogUtil.netLog("error statusCode:=" + statusCode + " ,"
                                             //                + "reponse: = " + response + ",error message = " + throwable.getMessage());

                                             AdLogUtil.netLog(str
                                                     + " ----- error statusCode = " + statusCode
                                                     + " ----- error message = " + throwable.getMessage()
                                                     + " ----- response = " + response
                                             );
                                         }

                                         if (mListener != null) {
                                             mListener.onServerRequestFailure(statusCode, response, throwable);
                                         }
                                     }
                                 }

                        );
            }

        } catch (Throwable e) {
            AdLogUtil.netLog("AdPSServerRequest --> " + Log.getStackTraceString(e));
            if (mListener != null) {
                mListener.onServerRequestFailure(new TaErrorCode(TaErrorCode.UNKNOWN_ERROR_CODE, e.getMessage()));
            }
        }
    }
}
