package com.cloud.hisavana.sdk.common.ps;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.common.activity.TAdExposureActivity;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdPsResponseBody;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.widget.TranCircleImageView;
import com.transsion.core.utils.ScreenUtil;

import java.util.List;


/**
 * ps中间页弹窗
 */
public class PsAdActivity extends Activity {

    // 传递过来的数据
    private AdsDTO adsDTO;
    private String gpLink;
    private List<String> gpLinkList;
    private List<AdPsResponseBody.PsLinkListDTO> psLinkListDTOS;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        setTitle(null);
        super.onCreate(savedInstanceState);
        setContentView(R.layout.dialog_ad_ps);

        // 传递过来的数据
        if (getIntent() != null) {
            if (getIntent().getSerializableExtra(TAdExposureActivity.TAG_AD) != null
                    && getIntent().getSerializableExtra(TAdExposureActivity.TAG_AD) instanceof AdsDTO) {
                adsDTO = (AdsDTO) getIntent().getSerializableExtra(TAdExposureActivity.TAG_AD);
            }
            if (getIntent().getSerializableExtra(PsRequestManager.INTENT_TAG_RESPONSEDATA) != null
                    && getIntent().getSerializableExtra(PsRequestManager.INTENT_TAG_RESPONSEDATA) instanceof AdPsResponseBody.DataDTO) {
                AdPsResponseBody.DataDTO responseData = (AdPsResponseBody.DataDTO) getIntent().getSerializableExtra(PsRequestManager.INTENT_TAG_RESPONSEDATA);
                if (responseData != null) {
                    psLinkListDTOS = responseData.getPsLinkList();
                    gpLinkList = responseData.getGpLinkList();
                }
            }
            gpLink = getIntent().getStringExtra(PsRequestManager.INTENT_TAG_GPLINK);
        }

        if (null == adsDTO || TextUtils.isEmpty(gpLink) || psLinkListDTOS == null || gpLinkList == null) {
            AdLogUtil.Log().d(CommonLogUtil.TAG, "PsAdActivity --> data null");
            this.finish();
            return;
        }
        //ps弹窗展现埋点
        AthenaTracker.trackPsPopupImp(adsDTO, gpLinkList, psLinkListDTOS);
        // 全屏显示 必须在setContentViw之后设置全屏。否则不会生效。
        getWindow().setLayout(getWindowManager().getDefaultDisplay().getWidth() - ScreenUtil.dip2px(48), ViewGroup.LayoutParams.MATCH_PARENT);
        //设置点击外部空白处可以关闭Activity true:可以关闭 false:不能关闭
        this.setFinishOnTouchOutside(false);

        initView();
    }


    /**
     * 初始化 View
     */
    private void initView() {
        TranCircleImageView ivIcon = findViewById(R.id.ivIcon);
        ImageView ivCancel = findViewById(R.id.ivCancel);
        TextView tvName = findViewById(R.id.tvName);
        TextView tvBtn = findViewById(R.id.tvBtn);
        RecyclerView recyclerView_gplink = findViewById(R.id.recycler);
        RecyclerView recycler_recommend = findViewById(R.id.recycler_recommend);
        String titleTxt = adsDTO.getApplicationTitle();
        if (!TextUtils.isEmpty(titleTxt)) {
            tvName.setText(titleTxt);
        }
        if (adsDTO.getNativeObject() != null) {
            if (adsDTO.getNativeObject().getLogo() != null && !TextUtils.isEmpty(adsDTO.getNativeObject().getLogo().getUrl())) {
                PsRequestManager.renderImageView(adsDTO.getNativeObject().getLogo().getUrl(), ivIcon, null);
            }
            String buttonTxt = adsDTO.getNativeObject().getButtonTxt(adsDTO.getInstallApk());
            if (!TextUtils.isEmpty(buttonTxt)) {
                tvBtn.setText(buttonTxt);
            }
        }
        //立即安装按钮
        tvBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                //ps弹窗点击埋点
                AthenaTracker.trackPsPopupClick(adsDTO, Constants.CLICK_CONTENT_TYPE.CLICK_GPLINK);
                adsDTO.setCalledUrlType(Constants.CALLED_URL_TYPE.GPLINK);
                adsDTO.setPslinkAppName("");
                startDeeplink(gpLink);
            }
        });
        //关闭按钮
        ivCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                //ps弹窗点击埋点
                AthenaTracker.trackPsPopupClick(adsDTO, Constants.CLICK_CONTENT_TYPE.CLICK_CLOSE);
                PsAdActivity.this.finish();
            }
        });
        //gplinklist
        GpLinkRecyclerAdapter gpLinkRecyclerAdapter = new GpLinkRecyclerAdapter(this, gpLinkList);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this);
        linearLayoutManager.setOrientation(LinearLayoutManager.HORIZONTAL);
        recyclerView_gplink.setLayoutManager(linearLayoutManager);
        recyclerView_gplink.addItemDecoration(new MyDecoration());
        recyclerView_gplink.setAdapter(gpLinkRecyclerAdapter);
        //pslinklist
        PsLinkRecyclerAdapter psLinkRecyclerAdapter = new PsLinkRecyclerAdapter(this, psLinkListDTOS);
        if (psLinkListDTOS.size() == 2){
            recycler_recommend.setLayoutManager(new GridLayoutManager(this, 2));
        }else if(psLinkListDTOS.size() == 3){
            recycler_recommend.setLayoutManager(new GridLayoutManager(this, 3));
        }else{
            LinearLayoutManager linearLayoutManager1 = new LinearLayoutManager(this);
            linearLayoutManager1.setOrientation(LinearLayoutManager.HORIZONTAL);
            recycler_recommend.setLayoutManager(linearLayoutManager1);
        }
        recycler_recommend.addItemDecoration(new MyDecoration());
        //点击监听
        psLinkRecyclerAdapter.setOnViewItemClickListener(new PsLinkRecyclerAdapter.OnViewItemClickListener() {
            @Override
            public void onClick(String dplink, String psLinkAppName) {
                //ps弹窗点击埋点
                AthenaTracker.trackPsPopupClick(adsDTO, Constants.CLICK_CONTENT_TYPE.CLICK_PSLINK);
                adsDTO.setCalledUrlType(Constants.CALLED_URL_TYPE.PSLINK);
                adsDTO.setPslinkAppName(psLinkAppName);
                startDeeplink(dplink);
            }
        });
        recycler_recommend.setAdapter(psLinkRecyclerAdapter);


    }

    /**
     * 打开gplink和pslink
     */
    private void startDeeplink(final String linkUrl) {
        Intent intent = new Intent();
        Uri content_uri = Uri.parse(linkUrl);
        intent.setData(content_uri);
        intent.setAction("android.intent.action.VIEW");
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        try {
            startActivity(intent);
            //设置首次
            adsDTO.setDeepLinkUrlFirst(linkUrl);
            //上报deeplink事件
            AthenaTracker.trackDeeplink(adsDTO);
        } catch (Throwable e) {
            AdLogUtil.Log().e("deepLinkUrl error - " + Log.getStackTraceString(e));
        }
    }

    /**
     * 自定义adapter的分割线
     */
    public class MyDecoration extends RecyclerView.ItemDecoration {
        private int space = ScreenUtil.dip2px(5);
        @Override
        public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            int position = parent.getChildAdapterPosition(view);
            int totalCount = parent.getAdapter().getItemCount();
            if (position == 0) {//第一个
                outRect.left = 0;
                outRect.right = space;
            } else if (position == totalCount - 1) {//最后一个
                outRect.left = space;
                outRect.right = 0;
            } else {//中间其它的
                outRect.right = space;
                outRect.left = space;
            }
        }
    }


    /**
     * 切换系统设置后，关闭ps中间页弹窗
     * @param newConfig
     */
    @Override
    public void onConfigurationChanged(@android.support.annotation.NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        finish();
    }

    /**
     * 返回键不关闭弹窗
     */
    @Override
    public void onBackPressed() {
    }
}
