package com.cloud.hisavana.sdk.ad;

import com.cloud.hisavana.sdk.ad.base.AdxBaseAd;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.common.adapter.IInterstitial;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.transsion.core.utils.AppUtil;


/**
 * 插屏广告
 *
 * @author 孙志刚.
 * @date 2016/12/8.
 * ==================================
 * Copyright (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class AdxInterstitial extends AdxBaseAd implements IInterstitial {

    /**
     * 构造方法
     *
     * @param placementId
     */
    public AdxInterstitial(String placementId) {
        super(placementId, Constants.AdType.INTERSTITIAL);
    }

    @Override
    public String getBroadCastPrefix(AdsDTO adBean) {
        if (adBean != null) {
            return AppUtil.getPkgName() + "_adx_" + adBean.getId(); //例如：com.transsion.hilauncher_adx_1_show
        }
        return null;
    }

}
