package com.cloud.hisavana.sdk.api.adx.innerapi;


import static com.cloud.sdk.commonutil.util.CommonLogUtil.DEFAULT_TAG;

import com.cloud.hisavana.sdk.ad.base.AdxDefault;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;

import java.util.ArrayList;
import java.util.List;

public class ADefault {
    private List<AdxDefault> executors;

    public void loadDefault(List<AdxImpBean> list){
        executors = new ArrayList<>();
        for (AdxImpBean adxImpBean : list){
           executors.add(new AdxDefault(adxImpBean));
       }
        execute();
    }
//    public String getDefault(String pmid){
//        List<AdsDTO> list = AdxDefault.getDefaultAdItem(pmid,false);
//        StringBuffer result = new StringBuffer();
//        for (AdsDTO adsDTO : list){
//            result.append(adsDTO.toStringShort());
//        }
//        return result.toString();
//    }
    public void execute(){
        DefaultExecutor temp = null;
        DefaultExecutor head = null;
        for (AdxDefault impl : executors) {
            DefaultExecutor next = new DefaultExecutor(impl);
            if (temp == null) {
                head = next;
            } else {
                temp.nextExecutor(next);
            }
            temp = next;
        }
        if (head != null) {
            head.load();
        }
    }


    /**
     * 串行处理器
     */
    class DefaultExecutor {
        private DefaultExecutor nextExecutor;
        private AdxDefault aDefault;
        //在AdxDefault.load结束以后调用loadListerner.loadComplete()
        private final AdxDefault.LoadListerner loadListerner = new AdxDefault.LoadListerner() {
            @Override
            public void loadComplete(boolean isSuccess) {
                AdLogUtil.Log().w(DEFAULT_TAG,"*----> stop load default ad result - " + isSuccess);
                if (nextExecutor != null) {
                    nextExecutor.load();
                }
            }

            @Override
            public void loadCompleteAndTrack(boolean isSuccess, AdxImpBean adxImpBean, List<AdsDTO> mAdBeans, TaErrorCode adError) {
                AdLogUtil.Log().w(DEFAULT_TAG,"*----> stop load default ad result - " + isSuccess);
                if (mAdBeans != null && mAdBeans.size() > 0) {
                    AthenaTracker.trackSspReturn(mAdBeans, adError, adxImpBean);
                } else {
                    AthenaTracker.trackSspReturn(null, adError, adxImpBean);
                }
                if (nextExecutor != null) {
                    nextExecutor.load();
                }
            }
        };
        public DefaultExecutor(AdxDefault adxDefault){
            this.aDefault = adxDefault;
            this.aDefault.setLoadListerner(loadListerner);
        }

        public void nextExecutor(DefaultExecutor executor) {
            this.nextExecutor = executor;
        }
        public void load() {
            if (aDefault != null) {
                //开始加载数据
                aDefault.loadAd();
            }
        }
        public void destroy() {
            if (aDefault != null) {
                aDefault.destroy();
                aDefault = null;
            }
            if (nextExecutor != null) {
                nextExecutor.destroy();
            }
        }
    }

}
