package com.cloud.hisavana.sdk.common.athena;

import android.os.Bundle;

import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdPsResponseBody;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.sdk.commonutil.athena.AthenaUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by wenjing.luo on 2021/8/24.
 */

public class AthenaTracker {


    // 下载途径
    public static final int DOWNLOAD_WAY_HTTP_URL_CONNECTION = 1;
    public static final int DOWNLOAD_WAY_OKHTTP = 2;

    // 下载状态
    public static final int M_STATUS_STAR = 1;
    public static final int M_STATUS_SUCCESS = 2;
    public static final int M_STATUS_ERROR = 3;

    // 下载类型
    public static final int M_TYPE_LOGO = 1;
    public static final int M_TYPE_LARGE_IMG = 2;
    public static final int M_TYPE_AD_CHOICE_VIEW = 3;
    //1.4.0 ps素材
    public static final int M_TYPE_AD_PS = 4;



    /**
     * @return 获取公参
     */
    public static Bundle getBundle(Bundle bundle) {
        return AthenaUtil.getBundle(bundle);
    }


    /**
     * 展示上报新开一个子线程
     *
     * @param info
     */
    public static void trackShow(final AdsDTO info) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackShow(info);
            }
        });
    }
    /**
     * 展示上报新开一个子线程
     *
     * @param info
     */
    public static void trackBuildViewShow(final AdsDTO info) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackBuildViewShow(info);
            }
        });
    }

    /**
     * deeplink应用拉起成功上报
     *
     * @param info
     */
    public static void trackDeeplink(final AdsDTO info) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackDeeplink(info);
            }
        });
    }

    /**
     * SSP SDK 物料加载日志
     *
     * @param info 广告详情
     * @param requestType 请求方式 1. 从网络获取；2. 从本地缓存获取
     * @param downloadWay 下载方式 1.HttpUrlConnection 2.Okhttp  int
     * @param mStatus     下载状态 1.开始下载 2.下载成功 3.下载失败
     * @param errorCode   错误信息
     * @param mType       资源类型
     * @param cdn         资源来源
     * @param timeConsuming 耗时
     * @param fileSize   文件大小
     */
    public static void trackImageDownload(final AdsDTO info,
                                          final int requestType,
                                          final int downloadWay,
                                          final int mStatus,
                                          final int errorCode,
                                          final int mType,
                                          final String cdn,
                                          final long timeConsuming,
                                          final int fileSize) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackImageDownload(info,requestType, downloadWay, mStatus, errorCode, mType,cdn,timeConsuming,fileSize);
            }
        });
    }

    /**
     * Adm 调用
     */
    public static void trackImageDownload(final AdsDTO info, final int download_way, final int m_status, final String errorcode, final int m_type){
        trackImageDownload(info, 1,download_way, m_status, 1, m_type,"",1,1);
    }

    /**
     * 请求广告埋点
     *
     * @param info
     */
    public static void trackSspRequest(final AdxImpBean info) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspRequest(info);
            }
        });
    }

    /**
     * 返回广告埋点
     */
    public static void trackSspReturn(final List<AdsDTO> infos, final TaErrorCode adError, final AdxImpBean adxImpBean) {
        final List<AdsDTO> adsDTOs = new ArrayList();
        if (infos != null) {
            for (AdsDTO adsDTO : infos) {
                adsDTOs.add(adsDTO);
            }
        }
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspReturn(infos, adError, adxImpBean);
            }
        });
    }

    /**
     * 请求ps素材广点
     */
    public static void trackSspRequestPs(final AdsDTO info,final String gplink) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspRequestPs(info,gplink);
            }
        });
    }

    /**
     * 返回ps素材埋点
     */
    public static void trackSspReturnPs(final AdsDTO info, final List<String> gplinks,final List<AdPsResponseBody.PsLinkListDTO> psLinkListDTOS, final TaErrorCode adError) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspReturnPs(info, gplinks,psLinkListDTOS ,adError);
            }
        });
    }

    /**
     * ps弹窗展现
     */
    public static void trackPsPopupImp(final AdsDTO info, final List<String> gplinks,final List<AdPsResponseBody.PsLinkListDTO > psLinkListDTOS) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackPsPopupImp(info, gplinks, psLinkListDTOS);
            }
        });
    }

    /**
     * ps弹窗点击
     */
    public static void trackPsPopupClick(final AdsDTO info,final int clickContentType) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackPsPopupClick(info, clickContentType);
            }
        });
    }
    /**
     * webview重定向的埋点
     * @param info
     */
    public static void trackWebViewRedirect(final AdsDTO info) {
        AthenaUtil.trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackWebViewRedirect(info);
            }
        });
    }
}
