package com.cloud.hisavana.sdk.api.adx;


import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.request.AdRequest;
import com.cloud.hisavana.sdk.internal.interstitial.TranInterstitial;

/**
 * Created by jianbing.yu on 2019/2/22.
 *
 * 媒体入口
 */
public class TInterstitial {

    private static final String TAG = "InterstitialApi";
    private TranInterstitial mInterstitial = null;

    /**
     * 构造方法
     *
     * @param placementId
     */
    public TInterstitial(String placementId) {
        mInterstitial = new TranInterstitial(placementId);
    }


    // =============================================================================================


    /**
     * 设置是否是打底广告
     *
     * @param isDefaultAd
     */
    public void setDefaultAd(boolean isDefaultAd) {
        mInterstitial.setDefaultAd(isDefaultAd);
    }

    /**
     * 设置placementid
     *
     * @param placementId
     */
    public void setPlacementId(String placementId) {
        mInterstitial.setPlacementId(placementId);
    }

    /**
     * 设置请求类型
     * @param requestType
     */
    public void setRequestType(int requestType) {
        mInterstitial.setRequestType(requestType);
    }

    public void setListener(AdListener listener) {
        mInterstitial.setListener(listener);
    }

    public void setRequest(AdRequest aAdRequest){
        mInterstitial.setAdRequest(aAdRequest);
    }

    public void setRequestId(String requestId){
        mInterstitial.setRequestId(requestId);
    }

    public double getBidPrice(){
        return mInterstitial.getBidPrice();
    }

    public void setSecondPrice(double secondPrice){
        mInterstitial.setSecondPrice(secondPrice);
    }

    public String getDefaultAdRequestId() {
       return mInterstitial.getDefaultAdRequestId();
    }
    public boolean isAdValid() {
        return mInterstitial.isAdValid();
    }

    public void loadAd(){
        mInterstitial.loadAd();
    }

    public void loadAd(String requestId){
        mInterstitial.loadAd(requestId);
    }
    public void show() {
        mInterstitial.show();
    }

    public boolean isLoaded() {
        return mInterstitial.isLoaded();
    }

    public void destroy() {
        mInterstitial.destroy();
    }
}
