package com.cloud.hisavana.sdk.api.adx;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.view.View;
import android.view.ViewGroup;

import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.view.AdChoicesView;
import com.cloud.hisavana.sdk.api.view.TNativeView;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.internal.native_.TranNative;

import java.util.List;

/**
 * Created by jianbing.yu on 2019/2/22.
 */
public class TNative {

    private final TranNative mNative;
    private static final String TAG = "NativeApi";


    // =============================================================================================


    public TNative(String placementId) {
        mNative = new TranNative(placementId);
    }


    // =============================================================================================


    public void setPlacementId(String placementId) {
        mNative.setPlacementId(placementId);
    }
    /**
     * 设置请求类型
     * @param requestType
     */
    public void setRequestType(int requestType) {
        mNative.setRequestType(requestType);
    }

    /**
     * 设置是否是打底广告
     *
     * @param isDefaultAd
     */
    public void setDefaultAd(boolean isDefaultAd) {
        mNative.setDefaultAd(isDefaultAd);
    }

    /**
     * 设置一次加载多少条
     *
     * @param adCount
     */
    public void setAdCount(int adCount) {
        mNative.setAdCount(adCount);
    }

    public void setListener(@NonNull AdListener listener) {
        mNative.setListener(listener);
    }

    public void setRequestId(String requestId){
        mNative.setRequestId(requestId);
    }

    public void loadAd() {
        mNative.loadAd();
    }

    public void loadAd(String requestId) {
        mNative.loadAd(requestId);
    }

    public boolean isAdValid(TaNativeInfo taNativeInfo) {
        return mNative.isAdValid(taNativeInfo);
    }

    public boolean isLoading() {
        return mNative.isLoading();
    }

    public void downloadMedia(TaNativeInfo ad) {
        mNative.downloadMedia(ad);
    }

    /**
     * 给广告相关的View注册监听事件
     */
    public int registerViews(@NonNull ViewGroup view, List<View> adContains, TaNativeInfo taNativeInfo) {
        return mNative.registerViews(view, adContains, taNativeInfo);
    }

    /**
     * 媒体端自己定义AdChoicesView的位置
     *
     * @param context
     * @param taNativeInfo
     * @return
     */
    public AdChoicesView getAdChoicesView(Context context, TaNativeInfo taNativeInfo) {
        return mNative.getAdChoicesView(context, taNativeInfo);
    }

    /**
     * 设置当前的广告类型
     * @param adSeatType native广告类型
     */
    public void setAdSeatType(String adSeatType){
        mNative.setAdSeatType(adSeatType);
    }

    /**
     * 释放资源
     */
    public void destroy() {
        mNative.destroy();
    }
}