package com.cloud.hisavana.sdk.api.adx;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.api.listener.OnSkipListener;
import com.cloud.hisavana.sdk.api.request.AdRequest;
import com.cloud.hisavana.sdk.internal.splash.TranSplash;
import com.cloud.sdk.commonutil.util.Preconditions;

/**
 * ADX开屏对外提供的接口
 * 仅仅提供容器的能力 不参与数据处理
 */
public class TSplash extends RelativeLayout {

    /**
     * 这个对象里面 解决了 数据哪里来的问题
     */
    protected TranSplash mSplash = null;

    private RelativeLayout mSplashLayout = null;


    // =============================================================================================


    public TSplash(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TSplash(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, "");
    }

    public TSplash(Context context, String placementId) {
        super(context, null);
        init(context, placementId);
    }

    /**
     * 初始化 创建了容器
     * 数据处理对象
     */
    private void init(Context context, String placementId) {
        mSplashLayout = new RelativeLayout(this.getContext());
        this.addView(mSplashLayout, ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        mSplash = new TranSplash(context, mSplashLayout, placementId);
    }


    // =============================================================================================

    /**
     * 设置广告位id
     */
    public void setPlacementId(String placementId) {
        mSplash.setPlacementId(placementId);
    }

    /**
     * 开屏允许外部 跳过
     */
    public void setAllowSkipOut(boolean mIsOpenDpl) {
        mSplash.setAllowSkipOut(mIsOpenDpl);
    }

    /**
     * 设置跳过的监听器
     */
    public void setSkipListener(OnSkipListener listener) {
        mSplash.setSkipListener(listener);
    }

    public void setListener(AdListener adListener){
        mSplash.setListener(adListener);
    }

    /**
     * 加载广告
     */
    public void loadAd() {
        mSplash.loadAd();
    }

    /**
     * 广告是否有效
     *
     * @return
     */
    public boolean isAdValid() {
        return mSplash.isAdValid();
    }

    /**
     * 显示广告 --> 在广告加载完成之后显示
     */
    public void show() {
        Preconditions.checkIsOnMainThread();
        mSplash.show();
    }

    /**
     * 在调用界面销毁的时候调用
     */
    public void destroy() {
        mSplash.destroy();
    }
}

